/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.ScriptTestUtils;
import org.openksavi.sponge.test.util.TestUtils;

public class EventsTestTemplate {
    private static String getValue(List<Event> events, int index) {
        return (String)((Map)events.get(index).get("map")).get("a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testClonePolicy(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithConfig(type, "events_clone_policy");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> TestUtils.getEvents(engine, "defaultClonePolicy").size() >= 3 && TestUtils.getEvents(engine, "deepClonePolicy").size() >= 3 && TestUtils.getEvents(engine, "shallowClonePolicy").size() >= 3);
            List<Event> defaultClonePolicyEvents = TestUtils.getEvents(engine, "defaultClonePolicy");
            Assertions.assertEquals((Object)"Value 1", (Object)EventsTestTemplate.getValue(defaultClonePolicyEvents, 0));
            Assertions.assertEquals((Object)"Value 2", (Object)EventsTestTemplate.getValue(defaultClonePolicyEvents, 1));
            Assertions.assertEquals((Object)"Value 3", (Object)EventsTestTemplate.getValue(defaultClonePolicyEvents, 2));
            List<Event> deepClonePolicyEvents = TestUtils.getEvents(engine, "deepClonePolicy");
            Assertions.assertEquals((Object)"Value 1", (Object)EventsTestTemplate.getValue(deepClonePolicyEvents, 0));
            Assertions.assertEquals((Object)"Value 2", (Object)EventsTestTemplate.getValue(deepClonePolicyEvents, 1));
            Assertions.assertEquals((Object)"Value 3", (Object)EventsTestTemplate.getValue(deepClonePolicyEvents, 2));
            List<Event> shallowClonePolicyEvents = TestUtils.getEvents(engine, "shallowClonePolicy");
            Assertions.assertEquals((Object)("Value " + defaultClonePolicyEvents.size()), (Object)EventsTestTemplate.getValue(shallowClonePolicyEvents, 0));
            Assertions.assertEquals((Object)("Value " + defaultClonePolicyEvents.size()), (Object)EventsTestTemplate.getValue(shallowClonePolicyEvents, 1));
            Assertions.assertEquals((Object)("Value " + defaultClonePolicyEvents.size()), (Object)EventsTestTemplate.getValue(shallowClonePolicyEvents, 2));
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testCron(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "events_cron");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "eventCounter")).intValue() >= 2);
            TimeUnit.SECONDS.sleep(5L);
            Assertions.assertEquals((int)2, (int)((Number)engine.getOperations().getVariable(Number.class, "eventCounter")).intValue());
            Assertions.assertFalse((boolean)engine.isError());
        }
        catch (InterruptedException ie) {
            throw new SpongeException((Throwable)ie);
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testRemovingEvent(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "events_removing");
        try {
            Awaitility.await().pollDelay(3L, TimeUnit.SECONDS).atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "eventCounter")).intValue() == ((Number)engine.getOperations().getVariable(Number.class, "allowNumber")).intValue());
            TimeUnit.SECONDS.sleep(2L);
            Assertions.assertEquals((int)((Number)engine.getOperations().getVariable(Number.class, "allowNumber")).intValue(), (int)((Number)engine.getOperations().getVariable(Number.class, "eventCounter")).intValue());
            Assertions.assertFalse((boolean)engine.isError());
        }
        catch (InterruptedException ie) {
            throw new SpongeException((Throwable)ie);
        }
        finally {
            engine.shutdown();
        }
    }
}

