/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.openksavi.sponge.core.engine.BaseSpongeEngine;
import org.openksavi.sponge.core.engine.DefaultSpongeEngine;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.examples.util.TestStatus;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.ScriptTestUtils;
import org.openksavi.sponge.test.util.TestUtils;

public class KnowledgeBaseTestTemplate {
    public static void testCallbacks(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "knowledge_base_callbacks");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable("onInitCalled")).get());
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable("onStartupCalled")).get());
            Awaitility.await().pollDelay(5L, TimeUnit.SECONDS).atMost(30L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable("onBeforeReloadCalled")).get());
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable("onAfterReloadCalled")).get());
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "onBeforeLoadCalled")).intValue() == 2);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "onLoadCalled")).intValue() == 2);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "onAfterLoadCalled")).intValue() == 2);
            TestStatus.onShutdownCalled = false;
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
        Assertions.assertTrue((boolean)TestStatus.onShutdownCalled);
    }

    public static void testLoad(KnowledgeBaseType type) {
        BaseSpongeEngine engine = DefaultSpongeEngine.builder().knowledgeBase("kb", new String[]{ScriptTestUtils.getScriptKnowledgeBaseFilename(type, "knowledge_base_load")}).build();
        engine.getConfigurationManager().setAutoEnable(false);
        engine.startup();
        try {
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> KnowledgeBaseTestTemplate.lambda$testLoad$7((SpongeEngine)engine));
            Assertions.assertTrue((TestUtils.getEventCounter((SpongeEngine)engine, "Trigger1, file1") > 1 ? 1 : 0) != 0);
            Assertions.assertTrue((TestUtils.getEventCounter((SpongeEngine)engine, "Trigger2, file1") > 1 ? 1 : 0) != 0);
            Assertions.assertTrue((TestUtils.getEventCounter((SpongeEngine)engine, "Trigger1, file2") > 1 ? 1 : 0) != 0);
            Assertions.assertTrue((TestUtils.getEventCounter((SpongeEngine)engine, "Trigger2, file2") > 1 ? 1 : 0) != 0);
            Assertions.assertEquals((int)0, (int)TestUtils.getEventCounter((SpongeEngine)engine, "Trigger3, file3"));
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testManager(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.buildWithKnowledgeBase(type, "knowledge_base_manager");
        engine.getConfigurationManager().setAutoEnable(false);
        engine.startup();
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable(AtomicBoolean.class, "verificationDone")).get());
            Assertions.assertTrue((boolean)((AtomicBoolean)engine.getOperations().getVariable(AtomicBoolean.class, "verifyTriggerEnabled")).get());
            Assertions.assertTrue((boolean)((AtomicBoolean)engine.getOperations().getVariable(AtomicBoolean.class, "verifyTriggerDisabled")).get());
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testAutoEnable(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "knowledge_base_auto_enable");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "counter")).intValue() >= 5);
            Assertions.assertEquals((int)5, (int)((Number)engine.getOperations().getVariable(Number.class, "counter")).intValue());
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    private static String getConcurrencyTestValue(SpongeEngine engine) {
        return (String)((AtomicReference)engine.getOperations().getVariable(AtomicReference.class, "value")).get();
    }

    public static void testConcurrency(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithConfig(type, "knowledge_base_concurrency");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> "A1".equals(KnowledgeBaseTestTemplate.getConcurrencyTestValue(engine)));
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> "B1".equals(KnowledgeBaseTestTemplate.getConcurrencyTestValue(engine)));
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> "A2".equals(KnowledgeBaseTestTemplate.getConcurrencyTestValue(engine)));
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> "B2".equals(KnowledgeBaseTestTemplate.getConcurrencyTestValue(engine)));
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> "C1".equals(KnowledgeBaseTestTemplate.getConcurrencyTestValue(engine)));
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> "C2".equals(KnowledgeBaseTestTemplate.getConcurrencyTestValue(engine)));
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testLibrary(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithConfig(type, "knowledge_base_library");
        try {
            Awaitility.await().pollDelay(5L, TimeUnit.SECONDS).atMost(60L, TimeUnit.SECONDS).until(() -> ((Map)engine.getOperations().getVariable("hostStatus")).size() >= 2);
            Map hostStatus = (Map)engine.getOperations().getVariable("hostStatus");
            Assertions.assertEquals((Object)"ERROR", hostStatus.get("www.wikipedia.org.unknown"));
            Assertions.assertTrue((Integer.decode(((String)hostStatus.get("www.wikipedia.org")).trim()) > 0 ? 1 : 0) != 0);
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testScriptOverriding(KnowledgeBaseType type) {
        BaseSpongeEngine engine = DefaultSpongeEngine.builder().config(ScriptTestUtils.getConfigFilename(type, "knowledge_base_script_overriding")).build();
        engine.getConfigurationManager().setAutoEnable(false);
        engine.startup();
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> KnowledgeBaseTestTemplate.lambda$testScriptOverriding$17((SpongeEngine)engine));
            Assertions.assertEquals((int)0, (int)((Number)engine.getOperations().getVariable(Number.class, "receivedEventA1")).intValue());
            Assertions.assertEquals((int)0, (int)((Number)engine.getOperations().getVariable(Number.class, "functionA1")).intValue());
            Assertions.assertEquals((int)2, (int)((Number)engine.getOperations().getVariable(Number.class, "functionA2")).intValue());
            Assertions.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    private static /* synthetic */ Boolean lambda$testScriptOverriding$17(SpongeEngine engine) throws Exception {
        return ((Number)engine.getOperations().getVariable(Number.class, "receivedEventA2")).intValue() == 2;
    }

    private static /* synthetic */ Boolean lambda$testLoad$7(SpongeEngine engine) throws Exception {
        return TestUtils.getEventCounter(engine, "Trigger1, file3") >= 20;
    }
}

