/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.ScriptTestUtils;

public class CorrelatorsTestTemplate {
    public static void testCorrelators(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "correlators");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureScriptFinishCount")).intValue() >= 1 && ((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureJavaFinishCount")).intValue() >= 1);
            Assert.assertEquals((long)4L, (long)((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureScriptCount")).intValue());
            Assert.assertEquals((long)4L, (long)((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureJavaCount")).intValue());
            Assert.assertEquals((long)1L, (long)((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureScriptFinishCount")).intValue());
            Assert.assertEquals((long)1L, (long)((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureJavaFinishCount")).intValue());
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testCorrelatorsRepeated(KnowledgeBaseType type) {
        CorrelatorsTestTemplate.testCorrelators(type);
    }

    public static void testCorrelatorsDuration(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "correlators_duration");
        try {
            Awaitility.await().pollDelay(5L, TimeUnit.SECONDS).atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "hardwareFailureScriptCount")).intValue() >= 3);
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }
}

