/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.openksavi.sponge.core.rule.BaseRule;
import org.openksavi.sponge.event.Event;

public class CorrelationEventsLog {
    public static final String VARIABLE_NAME = "correlationEventsLog";
    public static final String LABEL_ATTRIBUTE_NAME = "label";
    private Map<String, Map<String, List<List<Event>>>> events = Collections.synchronizedMap(new LinkedHashMap());
    private Lock lock = new ReentrantLock(true);

    public CorrelationEventsLog(String ... keys) {
        this.init(keys);
    }

    public CorrelationEventsLog() {
    }

    public void init(String ... keys) {
        for (String key : keys) {
            this.events.put(key, this.createMap());
        }
    }

    private Map<String, List<List<Event>>> createMap() {
        return Collections.synchronizedMap(new LinkedHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvents(String key, BaseRule rule) {
        this.lock.lock();
        try {
            List eventSequence = rule.getEventSequence();
            Event firstEvent = (Event)eventSequence.get(0);
            String firstLabel = (String)firstEvent.get(LABEL_ATTRIBUTE_NAME, String.class);
            assert (firstLabel != null) : firstEvent;
            if (!this.events.containsKey(key)) {
                this.events.put(key, this.createMap());
            }
            if (!this.events.get(key).containsKey(firstLabel)) {
                this.events.get(key).put(firstLabel, new ArrayList());
            }
            this.events.get(key).get(firstLabel).add(new ArrayList(eventSequence));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Event>> getEvents(String key, String firstEventLabel) {
        this.lock.lock();
        try {
            if (firstEventLabel == null) {
                List<List<Event>> list = this.getAllEvents(key);
                return list;
            }
            if (!this.events.containsKey(key) || !this.events.get(key).containsKey(firstEventLabel)) {
                List<List<Event>> list = Collections.emptyList();
                return list;
            }
            List<List<Event>> list = this.events.get(key).get(firstEventLabel);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<List<Event>> getAllEvents(String key) {
        this.lock.lock();
        try {
            if (!this.events.containsKey(key)) {
                List<List<Event>> list = Collections.emptyList();
                return list;
            }
            List<List<Event>> list = this.events.get(key).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.events.clear();
    }
}

