/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.examples;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.java.JRule;
import org.openksavi.sponge.rule.EventCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameSourceJavaUnorderedRule
extends JRule {
    private static final Logger logger = LoggerFactory.getLogger(SameSourceJavaUnorderedRule.class);

    public void onConfigure() {
        this.setEvents(new String[]{"filesystemFailure e1", "diskFailure e2 :all"});
        this.setOrdered(false);
        this.addAllConditions(new String[]{"severityCondition"});
        this.addEventConditions("e2", new EventCondition[]{(rule, event) -> event.get("source").equals(rule.getFirstEvent().get("source")) && Duration.between(rule.getFirstEvent().getTime(), event.getTime()).getSeconds() <= 4L});
        this.setDuration(Duration.ofSeconds(5L));
    }

    public void onRun(Event event) {
        logger.info("Monitoring log [{}]: Critical failure in {}! Events: {}", new Object[]{event.getTime(), event.get("source"), this.getEventSequence()});
        ((AtomicInteger)this.getSponge().getVariable(AtomicInteger.class, "hardwareFailureJavaCount")).incrementAndGet();
    }

    public boolean severityCondition(Event event) {
        return ((Number)event.get("severity", Number.class)).intValue() > 5;
    }
}

