/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.ScriptTestUtils;
import org.openksavi.sponge.test.util.TestUtils;

public class FiltersTestTemplate {
    public static void testJavaFilter(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "filters_java");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> TestUtils.getEventCounter(engine, "e2") >= 5 && TestUtils.getEventCounter(engine, "e3") >= 5);
            TimeUnit.SECONDS.sleep(1L);
            Assert.assertEquals((long)0L, (long)TestUtils.getEventCounter(engine, "e1"));
            Assert.assertFalse((boolean)engine.isError());
        }
        catch (InterruptedException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testFilter(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "filters");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> TestUtils.getEventCounter(engine, "blue") >= 1);
            TimeUnit.SECONDS.sleep(1L);
            Assert.assertEquals((long)0L, (long)TestUtils.getEventCounter(engine, "red"));
            Assert.assertFalse((boolean)engine.isError());
        }
        catch (InterruptedException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testDeduplication(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "filters_deduplication");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> TestUtils.getEventCounter(engine, "e1-red") >= 1 && TestUtils.getEventCounter(engine, "e1-blue") >= 1 && TestUtils.getEventCounter(engine, "e2-red") >= 2 && TestUtils.getEventCounter(engine, "e2-blue") >= 2);
            Assert.assertEquals((long)1L, (long)TestUtils.getEventCounter(engine, "e1-red"));
            Assert.assertEquals((long)1L, (long)TestUtils.getEventCounter(engine, "e1-blue"));
            Assert.assertEquals((long)2L, (long)TestUtils.getEventCounter(engine, "e2-red"));
            Assert.assertEquals((long)2L, (long)TestUtils.getEventCounter(engine, "e2-blue"));
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }
}

