/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.action.ArgMeta;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.ScriptTestUtils;
import org.openksavi.sponge.type.StringType;

public class ActionsTestTemplate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testActions(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "actions");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> engine.getOperations().getVariable("scriptActionResult") != null);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> engine.getOperations().getVariable("javaActionResult") != null);
            Object scriptResultObject = engine.getOperations().getVariable("scriptActionResult");
            List scriptResult = scriptResultObject instanceof List ? (List)scriptResultObject : Arrays.stream((Object[])scriptResultObject).collect(Collectors.toList());
            Assert.assertEquals((long)2L, (long)scriptResult.size());
            Assert.assertEquals((long)1L, (long)((Number)scriptResult.get(0)).intValue());
            Assert.assertEquals((Object)"test", scriptResult.get(1));
            Object[] javaResult = (Object[])engine.getOperations().getVariable("javaActionResult");
            Assert.assertEquals((long)2L, (long)javaResult.length);
            Assert.assertEquals((long)2L, (long)((Number)javaResult[0]).intValue());
            Assert.assertEquals((Object)"TEST", (Object)javaResult[1]);
            Assert.assertEquals((long)3L, (long)((Number)engine.getOperations().call(Number.class, "ArrayArgumentAction", Arrays.asList(new Object[]{new Object[]{1, 2, "text"}}))).intValue());
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testHelloWorldAction(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "actions_hello_world");
        try {
            String actionName = "HelloWorldAction";
            ActionAdapter adapter = engine.getActionManager().getActionAdapter(actionName);
            Assert.assertEquals((Object)actionName, (Object)adapter.getName());
            Assert.assertEquals((Object)"Hello world", (Object)adapter.getDisplayName());
            Assert.assertEquals((Object)"Returns a greeting text.", (Object)adapter.getDescription());
            Assert.assertEquals((long)1L, (long)adapter.getArgsMeta().size());
            Assert.assertTrue((boolean)adapter.getFeatures().isEmpty());
            ArgMeta argMeta = (ArgMeta)adapter.getArgsMeta().get(0);
            Assert.assertEquals((Object)"name", (Object)argMeta.getName());
            Assert.assertEquals((Object)"Your name", (Object)argMeta.getDisplayName());
            Assert.assertEquals((Object)"Type your name.", (Object)argMeta.getDescription());
            Assert.assertTrue((boolean)(argMeta.getType() instanceof StringType));
            Assert.assertEquals((Object)"Greeting", (Object)adapter.getResultMeta().getDisplayName());
            Assert.assertEquals((Object)"The greeting text.", (Object)adapter.getResultMeta().getDescription());
            Assert.assertTrue((boolean)(adapter.getResultMeta().getType() instanceof StringType));
            String name = "Sponge user";
            Assert.assertEquals((Object)String.format("Hello World! Hello %s!", name), (Object)engine.getOperations().call(actionName, Arrays.asList(name)));
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }
}

