/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.script.template;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.test.util.ScriptTestUtils;

public class TriggersTestTemplate {
    public static void testTriggers(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithConfig(type, "triggers");
        try {
            Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).atMost(30L, TimeUnit.SECONDS).until(() -> ((AtomicBoolean)engine.getOperations().getVariable(AtomicBoolean.class, "receivedEventA")).get());
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "receivedEventBCount")).intValue() > 2);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "receivedEventTestJavaCount")).intValue() == 1);
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testTriggersEventPattern(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithKnowledgeBase(type, "triggers_event_pattern");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "countA")).intValue() >= 2);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((Number)engine.getOperations().getVariable(Number.class, "countAPattern")).intValue() >= 5);
            Assert.assertEquals((long)2L, (long)((Number)engine.getOperations().getVariable(Number.class, "countA")).intValue());
            Assert.assertEquals((long)5L, (long)((Number)engine.getOperations().getVariable(Number.class, "countAPattern")).intValue());
            Assert.assertFalse((boolean)engine.isError());
        }
        finally {
            engine.shutdown();
        }
    }

    public static void testTriggersEventPatternIncorrect(KnowledgeBaseType type) {
        SpongeEngine engine = null;
        try {
            engine = ScriptTestUtils.startWithKnowledgeBase(type, "triggers_event_pattern_incorrect");
            Assert.fail((String)"Expected pattern syntax exception");
        }
        catch (SpongeException e) {
            if (ExceptionUtils.indexOfThrowable((Throwable)e, PatternSyntaxException.class) < 0) {
                throw e;
            }
        }
        finally {
            if (engine != null) {
                engine.shutdown();
            }
        }
    }

    public static void testHelloWorld(KnowledgeBaseType type) {
        SpongeEngine engine = ScriptTestUtils.startWithConfig(type, "triggers_hello_world");
        try {
            TimeUnit.SECONDS.sleep(1L);
            Assert.assertFalse((boolean)engine.isError());
        }
        catch (InterruptedException e) {
            throw new SpongeException((Throwable)e);
        }
        finally {
            engine.shutdown();
        }
    }
}

