/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.test.util;

import org.openksavi.sponge.core.engine.BaseSpongeEngine;
import org.openksavi.sponge.core.engine.DefaultSpongeEngine;
import org.openksavi.sponge.core.engine.EngineBuilder;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseType;

public class ScriptTestUtils {
    public static String getConfigFileName(KnowledgeBaseType type, String config) {
        if (type.isScript()) {
            return "examples/script/" + (String)type.getFileExtensions().get(0) + "/" + config + ".xml";
        }
        return "org/openksavi/sponge/" + type.getLanguage() + "/examples/" + config + ".xml";
    }

    public static String getScriptKnowledgeBaseDir(KnowledgeBaseType type) {
        return "examples/script/" + (String)type.getFileExtensions().get(0);
    }

    public static String getScriptKnowledgeBaseFileName(KnowledgeBaseType type, String knowledgeBaseFile) {
        return ScriptTestUtils.getScriptKnowledgeBaseDir(type) + "/" + knowledgeBaseFile + "." + (String)type.getFileExtensions().get(0);
    }

    public static String getNoScriptKnowledgeBaseClassName(KnowledgeBaseType type, String knowledgeBaseSimpleClassNameUnderscore) {
        return "org.openksavi.sponge." + type.getLanguage() + ".examples." + SpongeUtils.toUpperCamelCaseFromUnderscore((String)knowledgeBaseSimpleClassNameUnderscore);
    }

    public static SpongeEngine buildWithKnowledgeBase(KnowledgeBaseType type, String knowledgeBaseFile) {
        EngineBuilder builder = DefaultSpongeEngine.builder();
        if (type.isScript()) {
            builder.knowledgeBase("kb", type, new String[]{ScriptTestUtils.getScriptKnowledgeBaseFileName(type, knowledgeBaseFile)});
        } else {
            builder.knowledgeBase((KnowledgeBase)SpongeUtils.createInstance((String)ScriptTestUtils.getNoScriptKnowledgeBaseClassName(type, knowledgeBaseFile), KnowledgeBase.class));
        }
        return builder.build();
    }

    public static SpongeEngine startWithKnowledgeBase(KnowledgeBaseType type, String knowledgeBaseFile) {
        SpongeEngine engine = ScriptTestUtils.buildWithKnowledgeBase(type, knowledgeBaseFile);
        engine.startup();
        return engine;
    }

    public static SpongeEngine startWithConfig(KnowledgeBaseType type, String config) {
        BaseSpongeEngine engine = DefaultSpongeEngine.builder().config(ScriptTestUtils.getConfigFileName(type, config)).build();
        engine.startup();
        return engine;
    }
}

