/*
 * Decompiled with CFR 0.152.
 */
package org.openl.info;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.openl.info.OpenLLogger;
import org.openl.info.OpenLVersion;

final class SysInfoLogger
extends OpenLLogger {
    SysInfoLogger() {
    }

    @Override
    protected String getName() {
        return "sys";
    }

    @Override
    protected void discover() {
        this.log("System info:");
        try {
            this.log("    Java : {} v{} ({})", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("java.class.version"));
            this.log("      OS : {} v{} ({})", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        }
        catch (Exception ignored) {
            this.log("##### Cannot access to the System properties");
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            this.log("     ENV : {} CPU    Memory : Max={}   Committed={}   Used={}", Integer.toString(runtime.availableProcessors()), this.toMiB(runtime.maxMemory()), this.toMiB(runtime.totalMemory()), this.toMiB(runtime.totalMemory() - runtime.freeMemory()));
        }
        catch (Exception ignored) {
            this.log("##### Cannot access to the Runtime environment");
        }
        try {
            this.log("    Time : {} ({} - {})", new SimpleDateFormat("yyyy-MM-dd   HH:mm:ss.SSS XXX (z)").format(new Date()), TimeZone.getDefault().getID(), TimeZone.getDefault().getDisplayName());
            this.log("  Locale : {}", Locale.getDefault());
        }
        catch (Exception ignored) {
            this.log("##### Cannot access to the TimeZone or Locale");
        }
        try {
            this.log("Work dir : {}", Paths.get("", new String[0]).toAbsolutePath());
        }
        catch (Exception ignored) {
            this.log("##### Cannot access to the FileSystem");
        }
        try {
            this.log("App path : {}", OpenLVersion.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        }
        catch (Exception ignored) {
            this.log("##### Cannot access to the Application location");
        }
    }

    public void memStat() {
        try {
            System.gc();
            Thread.sleep(100L);
            Runtime runtime = Runtime.getRuntime();
            this.log("Memory : Max={}   Committed={}   Used={}", this.toMiB(runtime.maxMemory()), this.toMiB(runtime.totalMemory()), this.toMiB(runtime.totalMemory() - runtime.freeMemory()));
        }
        catch (Exception ignored) {
            this.log("##### Cannot access to the Runtime environment");
        }
        try {
            List<MemoryPoolMXBean> memPools = ManagementFactory.getMemoryPoolMXBeans();
            memPools.sort(Comparator.comparing(MemoryPoolMXBean::getName));
            this.log("----- Memory Usage in MiB -----     Init        Used    peak     Committed  peak         Max  ----- Type -----");
            for (MemoryPoolMXBean pool : memPools) {
                MemoryUsage usage = pool.getUsage();
                if (usage == null) continue;
                MemoryUsage peak = pool.getPeakUsage();
                peak = peak == null ? new MemoryUsage(0L, 0L, 0L, 0L) : peak;
                this.log("{} {}     {} {}     {} {}     {}   {}", String.format("%-32s", pool.getName()), this.toMiBAlign(usage.getInit()), this.toMiBAlign(usage.getUsed()), this.toMiBAlign(peak.getUsed()), this.toMiBAlign(usage.getCommitted()), this.toMiBAlign(peak.getCommitted()), this.toMiBAlign(usage.getMax()), String.format("%15s", new Object[]{pool.getType()}));
            }
        }
        catch (Exception ignored) {
            this.log("##### Cannot access to the Runtime environment");
        }
    }

    private String toMiB(long bytes) {
        return String.format("%.1f MiB", (double)bytes / 1024.0 / 1024.0);
    }

    private String toMiBAlign(long bytes) {
        if (bytes < 0L) {
            return "       ";
        }
        if (bytes == 0L) {
            return "     0 ";
        }
        return String.format("%7.1f", (double)bytes / 1024.0 / 1024.0);
    }
}

