/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.openl.util.AOpenIterator;

public abstract class AIndexedIterator<T>
extends AOpenIterator<T> {
    private final int from;
    private int current;
    private final int step;
    private final int to;

    public static Iterator<Object> fromArrayObj(Object ary) {
        if (ary == null) {
            return AIndexedIterator.empty();
        }
        return new AnyArrayIterator(ary);
    }

    protected AIndexedIterator(int from, int to, int step) {
        this.from = from;
        this.to = to;
        this.step = step;
        this.current = from;
    }

    @Override
    public final boolean hasNext() {
        return this.step > 0 ? this.current < this.to : this.current > this.to;
    }

    protected abstract T indexedElement(int var1);

    @Override
    public T next() {
        int idx = this.current;
        this.current += this.step;
        return this.indexedElement(idx);
    }

    @Override
    public final int size() {
        return this.step > 0 ? (this.to - this.from) / this.step : (this.from - this.to) / -this.step;
    }

    static class AnyArrayIterator
    extends AIndexedIterator<Object> {
        private final Object ary;

        private AnyArrayIterator(Object ary) {
            super(0, Array.getLength(ary), 1);
            this.ary = ary;
        }

        @Override
        protected Object indexedElement(int i) {
            return Array.get(this.ary, i);
        }
    }
}

