/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openl.util.IOpenIterator;

public abstract class AOpenIterator<T>
implements IOpenIterator<T> {
    public static final EmptyIterator<?> EMPTY_ITERATOR = new EmptyIterator();

    public static <T> IOpenIterator<T> empty() {
        return EMPTY_ITERATOR;
    }

    @Override
    public void remove() {
        throw new IllegalStateException();
    }

    @Override
    public int size() {
        return -1;
    }

    static final class EmptyIterator<T>
    extends AOpenIterator<T> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException("EmptyIterator");
        }

        @Override
        public int size() {
            return 0;
        }
    }

    static class SimpleIteratorWrapper<T>
    extends IteratorWrapper<T, T> {
        SimpleIteratorWrapper(Iterator<T> it) {
            super(it);
        }

        @Override
        public T next() {
            return (T)this.it.next();
        }
    }

    static abstract class IteratorWrapper<T, C>
    extends AOpenIterator<C> {
        protected final Iterator<T> it;

        IteratorWrapper(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public abstract C next();
    }
}

