/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.regex.Pattern;

public final class ClassUtils {
    private static final Pattern PACKAGE_NAME = Pattern.compile("(?!^abstract$|^abstract\\..*|.*\\.abstract\\..*|.*\\.abstract$|^assert$|^assert\\..*|.*\\.assert\\..*|.*\\.assert$|^boolean$|^boolean\\..*|.*\\.boolean\\..*|.*\\.boolean$|^break$|^break\\..*|.*\\.break\\..*|.*\\.break$|^byte$|^byte\\..*|.*\\.byte\\..*|.*\\.byte$|^case$|^case\\..*|.*\\.case\\..*|.*\\.case$|^catch$|^catch\\..*|.*\\.catch\\..*|.*\\.catch$|^char$|^char\\..*|.*\\.char\\..*|.*\\.char$|^class$|^class\\..*|.*\\.class\\..*|.*\\.class$|^const$|^const\\..*|.*\\.const\\..*|.*\\.const$|^continue$|^continue\\..*|.*\\.continue\\..*|.*\\.continue$|^default$|^default\\..*|.*\\.default\\..*|.*\\.default$|^do$|^do\\..*|.*\\.do\\..*|.*\\.do$|^double$|^double\\..*|.*\\.double\\..*|.*\\.double$|^else$|^else\\..*|.*\\.else\\..*|.*\\.else$|^enum$|^enum\\..*|.*\\.enum\\..*|.*\\.enum$|^extends$|^extends\\..*|.*\\.extends\\..*|.*\\.extends$|^final$|^final\\..*|.*\\.final\\..*|.*\\.final$|^finally$|^finally\\..*|.*\\.finally\\..*|.*\\.finally$|^float$|^float\\..*|.*\\.float\\..*|.*\\.float$|^for$|^for\\..*|.*\\.for\\..*|.*\\.for$|^goto$|^goto\\..*|.*\\.goto\\..*|.*\\.goto$|^if$|^if\\..*|.*\\.if\\..*|.*\\.if$|^implements$|^implements\\..*|.*\\.implements\\..*|.*\\.implements$|^import$|^import\\..*|.*\\.import\\..*|.*\\.import$|^instanceof$|^instanceof\\..*|.*\\.instanceof\\..*|.*\\.instanceof$|^int$|^int\\..*|.*\\.int\\..*|.*\\.int$|^interface$|^interface\\..*|.*\\.interface\\..*|.*\\.interface$|^long$|^long\\..*|.*\\.long\\..*|.*\\.long$|^native$|^native\\..*|.*\\.native\\..*|.*\\.native$|^new$|^new\\..*|.*\\.new\\..*|.*\\.new$|^package$|^package\\..*|.*\\.package\\..*|.*\\.package$|^private$|^private\\..*|.*\\.private\\..*|.*\\.private$|^protected$|^protected\\..*|.*\\.protected\\..*|.*\\.protected$|^public$|^public\\..*|.*\\.public\\..*|.*\\.public$|^return$|^return\\..*|.*\\.return\\..*|.*\\.return$|^short$|^short\\..*|.*\\.short\\..*|.*\\.short$|^static$|^static\\..*|.*\\.static\\..*|.*\\.static$|^strictfp$|^strictfp\\..*|.*\\.strictfp\\..*|.*\\.strictfp$|^super$|^super\\..*|.*\\.super\\..*|.*\\.super$|^switch$|^switch\\..*|.*\\.switch\\..*|.*\\.switch$|^synchronized$|^synchronized\\..*|.*\\.synchronized\\..*|.*\\.synchronized$|^this$|^this\\..*|.*\\.this\\..*|.*\\.this$|^throw$|^throw\\..*|.*\\.throw\\..*|.*\\.throw$|^throws$|^throws\\..*|.*\\.throws\\..*|.*\\.throws$|^transient$|^transient\\..*|.*\\.transient\\..*|.*\\.transient$|^try$|^try\\..*|.*\\.try\\..*|.*\\.try$|^void$|^void\\..*|.*\\.void\\..*|.*\\.void$|^volatile$|^volatile\\..*|.*\\.volatile\\..*|.*\\.volatile$|^while$|^while\\..*|.*\\.while\\..*|.*\\.while$)(^(?:[a-z_]+(?:\\d*[a-zA-Z_]*)*)(?:\\.[a-z_]+(?:\\d*[a-zA-Z_]*)*)*$)");

    private ClassUtils() {
    }

    public static ClassLoader getCurrentClassLoader(Class<?> clazz) {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && clazz != null) {
            cl = clazz.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        if (!cls.isPrimitive()) {
            return cls;
        }
        if (cls == Double.TYPE) {
            return Double.class;
        }
        if (cls == Integer.TYPE) {
            return Integer.class;
        }
        if (cls == Boolean.TYPE) {
            return Boolean.class;
        }
        if (cls == Long.TYPE) {
            return Long.class;
        }
        if (cls == Float.TYPE) {
            return Float.class;
        }
        if (cls == Void.TYPE) {
            return Void.TYPE;
        }
        if (cls == Character.TYPE) {
            return Character.class;
        }
        if (cls == Short.TYPE) {
            return Short.class;
        }
        if (cls == Byte.TYPE) {
            return Byte.class;
        }
        throw new IllegalStateException("No wrappers are for the primitive: " + String.valueOf(cls));
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        if (cls == Double.class) {
            return Double.TYPE;
        }
        if (cls == Integer.class) {
            return Integer.TYPE;
        }
        if (cls == Boolean.class) {
            return Boolean.TYPE;
        }
        if (cls == Long.class) {
            return Long.TYPE;
        }
        if (cls == Float.class) {
            return Float.TYPE;
        }
        if (cls == Void.TYPE) {
            return Void.TYPE;
        }
        if (cls == Character.class) {
            return Character.TYPE;
        }
        if (cls == Short.class) {
            return Short.TYPE;
        }
        if (cls == Byte.class) {
            return Byte.TYPE;
        }
        return null;
    }

    public static String getShortClassName(Class<?> cls) {
        if (cls == null) {
            return "";
        }
        String canonicalName = cls.getCanonicalName();
        if (canonicalName == null) {
            return "";
        }
        String packageName = ClassUtils.getPackageName(cls);
        if (packageName.isEmpty()) {
            return canonicalName;
        }
        return canonicalName.substring(packageName.length() + 1);
    }

    public static String getPackageName(Class<?> cls) {
        if (cls == null) {
            return "";
        }
        String className = cls.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        int arrayIndex = className.indexOf("[L");
        int start = arrayIndex == -1 ? 0 : arrayIndex + 2;
        return className.substring(start, lastDot);
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass) {
        if (cls == null && toClass == null) {
            return true;
        }
        if (toClass == null) {
            return !cls.isPrimitive();
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (toClass.isPrimitive() && !cls.isPrimitive()) {
            if ((cls = ClassUtils.wrapperToPrimitive(cls)) == null) {
                return false;
            }
        } else if (cls.isPrimitive() && !toClass.isPrimitive()) {
            cls = ClassUtils.primitiveToWrapper(cls);
        }
        if (cls == toClass) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE == cls) {
                return Long.TYPE == toClass || Float.TYPE == toClass || Double.TYPE == toClass;
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE == toClass || Double.TYPE == toClass;
            }
            if (Boolean.TYPE == cls) {
                return false;
            }
            if (Double.TYPE == cls) {
                return false;
            }
            if (Float.TYPE == cls) {
                return Double.TYPE == toClass;
            }
            if (Character.TYPE == cls || Short.TYPE == cls) {
                return Integer.TYPE == toClass || Long.TYPE == toClass || Float.TYPE == toClass || Double.TYPE == toClass;
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE == toClass || Integer.TYPE == toClass || Long.TYPE == toClass || Float.TYPE == toClass || Double.TYPE == toClass;
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static Class<?> commonType(Class<?> a, Class<?> b) {
        if (a == null || b == null) {
            return a == null ? b : a;
        }
        if (ClassUtils.isAssignable(b, a) && !a.isPrimitive()) {
            return a;
        }
        if (ClassUtils.isAssignable(a, b)) {
            return b;
        }
        if (ClassUtils.isAssignable(b, a)) {
            return a;
        }
        if (a.isArray() && b.isArray()) {
            Class<?> component = ClassUtils.commonType(a.getComponentType(), b.getComponentType());
            return Array.newInstance(component, 0).getClass();
        }
        if (!a.isPrimitive()) {
            return ClassUtils.commonType(a.getSuperclass(), b);
        }
        if (!b.isPrimitive()) {
            return ClassUtils.commonType(a, b.getSuperclass());
        }
        return Object.class;
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        if (Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    public static String decapitalize(String name) {
        return Introspector.decapitalize(name);
    }

    public static String getter(String name) {
        return "get" + ClassUtils.capitalize(name);
    }

    public static String setter(String name) {
        return "set" + ClassUtils.capitalize(name);
    }

    public static String toFieldName(String name) {
        return ClassUtils.decapitalize(name.substring(3));
    }

    public static boolean isValidPackageName(String packageName) {
        if (packageName == null) {
            return false;
        }
        return PACKAGE_NAME.matcher(packageName).matches();
    }

    public static void set(Object target, String fieldName, Object value) throws Exception {
        Class<?> clz = target.getClass();
        try {
            clz.getField(fieldName).set(target, value);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Method[] methods;
            Class<?> type = value != null ? value.getClass() : ClassUtils.getType(target, fieldName);
            String setterName = ClassUtils.setter(fieldName);
            Method setter = null;
            Method setter2 = null;
            for (Method method : methods = clz.getMethods()) {
                if (!method.getName().equals(setterName) || method.getParameterCount() != 1) continue;
                Class<?> parameterType = method.getParameterTypes()[0];
                if (ClassUtils.isAssignable(type, parameterType)) {
                    if (setter != null) {
                        Class<?> setterType = setter.getParameterTypes()[0];
                        if (ClassUtils.isAssignable(parameterType, setterType)) {
                            setter = method;
                        } else if (!ClassUtils.isAssignable(setterType, parameterType)) {
                            throw new IllegalArgumentException("Method '" + setterName + "(" + String.valueOf(type) + ")' is ambiguous in " + String.valueOf(clz));
                        }
                    } else {
                        setter = method;
                    }
                }
                setter2 = method;
            }
            if (setter == null) {
                setter = setter2;
            }
            if (setter == null) {
                throw new IllegalAccessException("Field '" + fieldName + "' is not accessible in class " + clz.getName());
            }
            try {
                setter.invoke(target, value);
            }
            catch (InvocationTargetException ex) {
                Throwable exception = ex.getTargetException();
                if (exception instanceof Exception) {
                    throw (Exception)exception;
                }
                throw ex;
            }
            return;
        }
    }

    public static Object get(Object target, String fieldName) throws Exception {
        Class<?> clz = target.getClass();
        try {
            return clz.getField(fieldName).get(target);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Method getter = ClassUtils.findGetterMethod(target, fieldName);
            if (getter == null) {
                throw new IllegalAccessException("Field '" + fieldName + "' is not accessible in class " + clz.getName());
            }
            try {
                return getter.invoke(target, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwable exception = ex.getTargetException();
                if (exception instanceof Exception) {
                    throw (Exception)exception;
                }
                throw ex;
            }
        }
    }

    public static Class<?> getType(Object target, String fieldName) {
        Class<?> type;
        try {
            type = target.getClass().getDeclaredField(fieldName).getType();
        }
        catch (NoSuchFieldException ignore) {
            Method getterMethod = ClassUtils.findGetterMethod(target, fieldName);
            type = getterMethod != null ? getterMethod.getReturnType() : null;
        }
        return type;
    }

    private static Method findGetterMethod(Object target, String fieldName) {
        try {
            return target.getClass().getMethod(ClassUtils.getter(fieldName), new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            try {
                return target.getClass().getMethod("is" + ClassUtils.capitalize(fieldName), new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }
    }
}

