/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.Arrays;
import java.util.function.IntPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String EMPTY = "";
    public static final String SPACE = " ";

    public static String[] split(String str, char separator) {
        return StringUtils.splitWorker(str, ch -> ch == separator);
    }

    public static String[] split(String str) {
        return StringUtils.splitWorker(str, Character::isWhitespace);
    }

    private static String[] splitWorker(String str, IntPredicate tester) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        int count = 0;
        boolean match = false;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (tester.test(ch)) {
                match = false;
                continue;
            }
            if (match || StringUtils.isSpaceOrControl(ch)) continue;
            ++count;
            match = true;
        }
        if (count == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result = new String[count];
        int i = 0;
        int start = 0;
        int end = 0;
        match = false;
        count = 0;
        while (i < len) {
            char ch;
            if (tester.test(ch = str.charAt(i++))) {
                if (match) {
                    result[count] = str.substring(start, end);
                    match = false;
                    ++count;
                }
                start = i;
                continue;
            }
            if (StringUtils.isSpaceOrControl(ch)) {
                if (match) continue;
                start = i;
                continue;
            }
            match = true;
            end = i;
        }
        if (match) {
            result[count] = str.substring(start, end);
        }
        return result;
    }

    public static String[] toLines(String text) {
        if (StringUtils.isBlank(text)) {
            return null;
        }
        return text.trim().split("\\s*[\r\n]\\s*");
    }

    public static String join(Object[] values, String separator) {
        if (values == null) {
            return null;
        }
        return Arrays.stream(values).map(String::valueOf).collect(Collectors.joining(separator));
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return true;
        }
        return StringUtils.firstNonSpace(cs, 0, cs.length()) < 0;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean containsIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int len = searchStr.length();
        int end = str.length() - len;
        for (int i = 0; i <= end; ++i) {
            if (!str.regionMatches(true, i, searchStr, 0, len)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Pattern regex, CharSequence input) {
        Matcher m = regex.matcher(input);
        return m.matches();
    }

    public static String trim(String str) {
        int end;
        int start;
        if (str == null || str.isEmpty()) {
            return str;
        }
        for (start = 0; start < str.length() && StringUtils.isSpaceOrControl(str.charAt(start)); ++start) {
        }
        for (end = str.length(); start < end && StringUtils.isSpaceOrControl(str.charAt(end - 1)); --end) {
        }
        return start > 0 || end < str.length() ? str.substring(start, end) : str;
    }

    public static boolean isSpaceOrControl(int ch) {
        return ch <= 32 || Character.isWhitespace(ch) || Character.isISOControl(ch) || Character.isSpaceChar(ch);
    }

    public static String trimToNull(String str) {
        String ts = StringUtils.trim(str);
        return StringUtils.isEmpty(ts) ? null : ts;
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : StringUtils.trim(str);
    }

    public static String capitalize(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isTitleCase(firstChar)) {
            return str;
        }
        return Character.toTitleCase(firstChar) + str.substring(1);
    }

    public static String uncapitalize(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return str;
        }
        return Character.toLowerCase(firstChar) + str.substring(1);
    }

    public static String camelToKebab(String camel) {
        if (StringUtils.isEmpty(camel)) {
            return camel;
        }
        int length = camel.length();
        StringBuilder sb = new StringBuilder(length + length / 4 + 1);
        for (int i = 0; i < length; ++i) {
            char c = camel.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0 && (i < length - 1 && Character.isLowerCase(camel.charAt(i + 1)) || Character.isLowerCase(camel.charAt(i - 1)))) {
                    sb.append("-");
                }
                c = Character.toLowerCase(c);
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static int first(CharSequence text, int start, int end, IntPredicate tester) {
        end = Math.min(text.length(), end);
        for (int i = Math.max(start, 0); i < end; ++i) {
            char ch = text.charAt(i);
            if (!tester.test(ch)) continue;
            return i;
        }
        return -1;
    }

    public static int last(CharSequence text, int start, int end, IntPredicate tester) {
        start = Math.max(start, 0);
        for (int i = Math.min(text.length(), end) - 1; i >= start; --i) {
            char ch = text.charAt(i);
            if (!tester.test(ch)) continue;
            return i;
        }
        return -1;
    }

    public static int firstNonSpace(CharSequence text, int start, int end) {
        return StringUtils.first(text, start, end, ch -> !StringUtils.isSpaceOrControl(ch));
    }

    public static int lastNonSpace(CharSequence text, int start, int end) {
        return StringUtils.last(text, start, end, ch -> !StringUtils.isSpaceOrControl(ch));
    }
}

