/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDBUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlDBUtils.class);

    public static void safeClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                log.warn("Unexpected sql failure", (Throwable)e);
            }
        }
    }

    public static void safeClose(Connection connection) {
        if (connection != null) {
            try {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (Exception e) {
                log.warn("Failed to commit", (Throwable)e);
            }
            try {
                connection.close();
            }
            catch (Exception e) {
                log.warn("Unexpected sql failure", (Throwable)e);
            }
        }
    }

    public static void safeClose(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (Exception e) {
                log.warn("Unexpected sql failure", (Throwable)e);
            }
        }
    }
}

