/*
 * Decompiled with CFR 0.152.
 */
package org.openl.domain;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Iterator;
import org.openl.domain.AIntIterator;
import org.openl.domain.IDomain;
import org.openl.domain.IIntDomain;
import org.openl.domain.IIntIterator;
import org.openl.domain.IType;

public class IntRangeDomain
implements IDomain<Integer>,
IIntDomain {
    protected final int min;
    protected final int max;

    public IntRangeDomain(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean contains(int value) {
        return this.min <= value && value <= this.max;
    }

    public boolean containsNumber(Number n) {
        return (double)this.min <= n.doubleValue() && n.doubleValue() <= (double)this.max;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntRangeDomain)) {
            return false;
        }
        IntRangeDomain other = (IntRangeDomain)obj;
        return this.min == other.min && this.max == other.max;
    }

    @Override
    @XmlTransient
    public IType getElementType() {
        return null;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + this.min;
        hashCode = 31 * hashCode + this.max;
        return hashCode;
    }

    @Override
    public IIntIterator intIterator() {
        return new RangeIterator(1);
    }

    public IIntIterator iterate(int step) {
        return new RangeIterator(step);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.intIterator();
    }

    @Override
    public boolean selectObject(Integer n) {
        return this.containsNumber(n);
    }

    @Override
    public int size() {
        return this.max - this.min + 1;
    }

    public String toString() {
        if (this.min == Integer.MIN_VALUE) {
            return "<=" + this.max;
        }
        if (this.max == Integer.MAX_VALUE) {
            return ">=" + this.min;
        }
        return "[" + this.min + ".." + this.max + "]";
    }

    private class RangeIterator
    extends AIntIterator {
        private int current;
        private final int step;

        RangeIterator(int step) {
            this.current = IntRangeDomain.this.min;
            this.step = step;
        }

        @Override
        public boolean hasNext() {
            return this.current <= IntRangeDomain.this.max;
        }

        @Override
        public int nextInt() {
            int ret = this.current;
            this.current += this.step;
            return ret;
        }

        @Override
        public int size() {
            return (IntRangeDomain.this.max - IntRangeDomain.this.min + 1) / this.step;
        }

        @Override
        public boolean isResetable() {
            return true;
        }

        @Override
        public void reset() {
            this.current = IntRangeDomain.this.min;
        }
    }
}

