/*
 * Decompiled with CFR 0.152.
 */
package org.openl.info;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.openl.info.OpenLLogger;
import org.openl.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClasspathLogger
extends OpenLLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathLogger.class);

    ClasspathLogger() {
    }

    @Override
    protected String getName() {
        return "cp";
    }

    @Override
    protected void discover() {
        this.log("Libs in the classpath:");
        for (ClassLoader classLoader = ClassUtils.getCurrentClassLoader(this.getClass()); classLoader != null; classLoader = classLoader.getParent()) {
            URL[] urls;
            this.log(ClasspathLogger.getClassLoaderName(classLoader));
            if (!(classLoader instanceof URLClassLoader)) continue;
            for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
                this.log("  {}", url);
            }
        }
    }

    private static String getClassLoaderName(ClassLoader classLoader) {
        Class<?> clazz = classLoader.getClass();
        Object name = clazz.getName();
        try {
            Class<?> cls = clazz.getMethod("toString", new Class[0]).getDeclaringClass();
            if (cls != Object.class) {
                name = classLoader.toString() + "  Class: " + (String)name + " #" + System.identityHashCode(classLoader);
            }
        }
        catch (NoSuchMethodException cls) {
            // empty catch block
        }
        try {
            Method getName = clazz.getMethod("getName", new Class[0]);
            Object getNameStr = getName.invoke((Object)classLoader, new Object[0]);
            if (getNameStr != null) {
                name = (String)name + "  Name: " + getNameStr.toString();
            }
        }
        catch (Exception e) {
            LOG.debug("Ignored error: ", (Throwable)e);
        }
        return name;
    }
}

