/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CollectionUtils {
    public static boolean isEmpty(Collection<?> col) {
        return col == null || col.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> col) {
        return !CollectionUtils.isEmpty(col);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionUtils.isEmpty(map);
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !CollectionUtils.isEmpty(array);
    }

    public static <T> boolean isEmpty(T array) {
        return array == null || Array.getLength(array) == 0;
    }

    public static <T> boolean isNotEmpty(T array) {
        return !CollectionUtils.isEmpty(array);
    }

    public static <I, O> List<O> map(Iterable<I> col, Mapper<? super I, ? extends O> mapper) {
        if (col == null) {
            return null;
        }
        Objects.requireNonNull(mapper, "mapper cannot be null");
        int size = col instanceof Collection ? ((Collection)col).size() : 0;
        ArrayList<O> result = new ArrayList<O>(size);
        for (I input : col) {
            O output = mapper.map(input);
            result.add(output);
        }
        return result;
    }

    public static <T> T findFirst(Iterable<T> col, Predicate<? super T> predicate) {
        if (col == null) {
            return null;
        }
        Objects.requireNonNull(predicate, "predicate cannot be null");
        for (T item : col) {
            if (!predicate.evaluate(item)) continue;
            return item;
        }
        return null;
    }

    public static <T> List<T> findAll(Iterable<T> col, Predicate<? super T> predicate) {
        if (col == null) {
            return null;
        }
        Objects.requireNonNull(predicate, "predicate cannot be null");
        int size = col instanceof Collection ? ((Collection)col).size() : 0;
        ArrayList<T> result = new ArrayList<T>(size);
        for (T item : col) {
            if (!predicate.evaluate(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static <T> boolean hasNull(T[] array) {
        for (T item : array) {
            if (item != null) continue;
            return true;
        }
        return false;
    }

    public static Object toArray(Collection<?> list, Class<?> instanceClass) {
        if (list == null) {
            return null;
        }
        Object result = Array.newInstance(instanceClass, list.size());
        int i = 0;
        for (Object el : list) {
            Array.set(result, i, el);
            ++i;
        }
        return result;
    }

    public static interface Mapper<I, O> {
        public O map(I var1);
    }

    public static interface Predicate<T> {
        public boolean evaluate(T var1);
    }
}

