/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.ArrayList;
import java.util.List;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.MultiCallMethodBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.util.ArrayTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayArgumentsMethodBinder
extends ANodeBinder {
    private final Logger log = LoggerFactory.getLogger(ArrayArgumentsMethodBinder.class);
    private String methodName;
    private IOpenClass[] argumentsTypes;
    private IBoundNode[] children;

    public ArrayArgumentsMethodBinder(String methodName, IOpenClass[] argumentsTypes, IBoundNode[] children) {
        this.methodName = methodName;
        this.argumentsTypes = (IOpenClass[])argumentsTypes.clone();
        this.children = (IBoundNode[])children.clone();
    }

    private IBoundNode getMultiCallMethodNode(ISyntaxNode node, IBindingContext bindingContext, IOpenClass[] methodArguments, int arrayArgumentIndex) {
        IMethodCaller singleParameterMethodCaller = bindingContext.findMethodCaller("org.openl.this", this.methodName, methodArguments);
        if (singleParameterMethodCaller == null) {
            return null;
        }
        return new MultiCallMethodBoundNode(node, this.children, singleParameterMethodCaller, arrayArgumentIndex);
    }

    private List<Integer> getIndexesOfArrayArguments() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this.argumentsTypes.length; ++i) {
            if (!this.argumentsTypes[i].isArray()) continue;
            indexes.add(i);
        }
        return indexes;
    }

    private IOpenClass[] unwrapArguments(int arrayArgumentIndex) {
        if (arrayArgumentIndex < this.argumentsTypes.length) {
            IOpenClass unwrappedType = this.argumentsTypes[arrayArgumentIndex].getComponentClass();
            return (IOpenClass[])ArrayTool.replace((int)arrayArgumentIndex, (Object)this.argumentsTypes, (Object)unwrappedType);
        }
        this.log.warn("Can`t find the appropriate argument");
        return null;
    }

    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        List<Integer> indexesOfArrayArguments = this.getIndexesOfArrayArguments();
        if (indexesOfArrayArguments.size() > 0) {
            for (Integer arrayArgumentIndex : indexesOfArrayArguments) {
                IBoundNode multiCallMethodNode;
                IOpenClass[] unwrappedArgumentsTypes = this.unwrapArguments(arrayArgumentIndex);
                if (unwrappedArgumentsTypes == null || (multiCallMethodNode = this.getMultiCallMethodNode(node, bindingContext, unwrappedArgumentsTypes, arrayArgumentIndex)) == null) continue;
                return multiCallMethodNode;
            }
        } else {
            this.log.debug("There is no any array argument in signature for {} method", (Object)this.methodName);
        }
        return null;
    }
}

