/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ILocalVar;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.IndexParameterDeclarationBinder;
import org.openl.binding.impl.TypeBindingContext;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;

public abstract class BaseAggregateIndexNodeBinder
extends ANodeBinder {
    public abstract String getDefaultTempVarName(IBindingContext var1);

    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        BindHelper.processError((String)"This node always binds  with target", (ISyntaxNode)node, (IBindingContext)bindingContext);
        return new ErrorBoundNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBoundNode bindTarget(ISyntaxNode node, IBindingContext bindingContext, IBoundNode targetNode) throws Exception {
        try {
            IBoundNode boundNode;
            bindingContext.pushLocalVarContext();
            ILocalVar localVar = this.prepareLocalVar(node, bindingContext, targetNode);
            IBoundNode[] children = this.bindAndValidateChildren(node, bindingContext, localVar);
            IBoundNode iBoundNode = boundNode = this.createBoundNode(node, targetNode, children[0], localVar);
            return iBoundNode;
        }
        catch (SyntaxNodeException error) {
            BindHelper.processError((SyntaxNodeException)error);
            ErrorBoundNode errorBoundNode = new ErrorBoundNode(node);
            return errorBoundNode;
        }
        finally {
            bindingContext.popLocalVarContext();
        }
    }

    protected abstract IBoundNode createBoundNode(ISyntaxNode var1, IBoundNode var2, IBoundNode var3, ILocalVar var4);

    protected ILocalVar prepareLocalVar(ISyntaxNode node, IBindingContext bindingContext, IBoundNode targetNode) throws SyntaxNodeException {
        switch (node.getNumberOfChildren()) {
            case 1: {
                return this.prepareDefaultLocalVar(node, bindingContext, targetNode);
            }
            case 2: {
                return this.prepareDefinedLocalVar(node, bindingContext, targetNode);
            }
        }
        throw SyntaxNodeExceptionUtils.createError((String)"Aggregate node can have either 1 or 2 childen nodes", (ISyntaxNode)node);
    }

    private ILocalVar prepareDefinedLocalVar(ISyntaxNode node, IBindingContext bindingContext, IBoundNode targetNode) throws SyntaxNodeException {
        IOpenCast cast;
        IOpenClass varType;
        IOpenClass containerType = targetNode.getType();
        IAggregateInfo info = containerType.getAggregateInfo();
        IOpenClass componentType = info.getComponentType(containerType);
        IBoundNode localVarDefinitionBoundNode = BaseAggregateIndexNodeBinder.bindChildNode((ISyntaxNode)node.getChild(0), (IBindingContext)bindingContext);
        IndexParameterDeclarationBinder.IndexParameterNode pnode = (IndexParameterDeclarationBinder.IndexParameterNode)localVarDefinitionBoundNode;
        String varName = pnode.getName();
        IOpenClass iOpenClass = varType = pnode.getType() == null ? componentType : pnode.getType();
        if (varType != componentType && (cast = bindingContext.getCast(componentType, varType)) == null) {
            BindHelper.processError((String)("Can not cast " + componentType + " to " + varType), (ISyntaxNode)node.getChild(0), (IBindingContext)bindingContext, (boolean)false);
        }
        ILocalVar var = bindingContext.addVar("org.openl.this", varName, varType);
        return var;
    }

    protected ILocalVar prepareDefaultLocalVar(ISyntaxNode node, IBindingContext bindingContext, IBoundNode targetNode) {
        IOpenClass containerType = targetNode.getType();
        IAggregateInfo info = containerType.getAggregateInfo();
        String varName = BindHelper.getTemporaryVarName((IBindingContext)bindingContext, (String)"org.openl.this", (String)this.getDefaultTempVarName(bindingContext));
        ILocalVar var = bindingContext.addVar("org.openl.this", varName, info.getComponentType(containerType));
        return var;
    }

    private IBoundNode[] bindAndValidateChildren(ISyntaxNode node, IBindingContext bindingContext, ILocalVar localVar) throws SyntaxNodeException {
        ISyntaxNode expressionNode = node.getNumberOfChildren() == 1 ? node.getChild(0) : node.getChild(1);
        IBoundNode boundExpressionNode = BaseAggregateIndexNodeBinder.bindChildNode((ISyntaxNode)expressionNode, (IBindingContext)TypeBindingContext.create((IBindingContext)bindingContext, (ILocalVar)localVar));
        boundExpressionNode = this.validateExpressionNode(boundExpressionNode, bindingContext);
        return new IBoundNode[]{boundExpressionNode};
    }

    protected abstract IBoundNode validateExpressionNode(IBoundNode var1, IBindingContext var2);
}

