/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.apache.commons.lang3.StringUtils;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMethodFactory;
import org.openl.binding.MethodUtil;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.ArrayArgumentsMethodBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.FieldAccessMethodBinder;
import org.openl.binding.impl.MethodBoundNode;
import org.openl.binding.impl.MethodSearch;
import org.openl.binding.impl.VariableLengthArgumentsMethodBinder;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.util.StringTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodNodeBinder
extends ANodeBinder {
    private static final String FIELD_ACCESS_METHOD = "field access method";
    private static final String VARIABLE_NUMBER_OF_ARGUMENTS_METHOD = "method with varialble number of arguments";
    private static final String ARRAY_ARGUMENT_METHOD = "array argument method";
    private static final String APPROPRIATE_BY_SIGNATURE_METHOD = "entirely appropriate by signature method";
    private static final String NO_PARAMETERS = "no parameters";
    private final Logger log = LoggerFactory.getLogger(MethodNodeBinder.class);

    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        IBoundNode[] children;
        IOpenClass[] parameterTypes;
        int childrenCount = node.getNumberOfChildren();
        if (childrenCount < 1) {
            BindHelper.processError((String)"Method node should have at least one subnode", (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        ISyntaxNode lastNode = node.getChild(childrenCount - 1);
        String methodName = ((IdentifierNode)lastNode).getIdentifier();
        IMethodCaller methodCaller = bindingContext.findMethodCaller("org.openl.this", methodName, parameterTypes = MethodNodeBinder.getTypes((IBoundNode[])(children = MethodNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext, (int)0, (int)(childrenCount - 1)))));
        if (methodCaller == null) {
            return this.bindWithAdditionalBinders(node, bindingContext, methodName, parameterTypes, children, childrenCount);
        }
        String bindingType = APPROPRIATE_BY_SIGNATURE_METHOD;
        this.log(methodName, parameterTypes, bindingType);
        return new MethodBoundNode(node, children, methodCaller);
    }

    protected IBoundNode makeArraParametersMethod(ISyntaxNode methodNode, IBindingContext bindingContext, String methodName, IOpenClass[] argumentTypes, IBoundNode[] children) throws Exception {
        return new ArrayArgumentsMethodBinder(methodName, argumentTypes, children).bind(methodNode, bindingContext);
    }

    private IBoundNode bindWithAdditionalBinders(ISyntaxNode methodNode, IBindingContext bindingContext, String methodName, IOpenClass[] argumentTypes, IBoundNode[] children, int childrenCount) throws Exception {
        IBoundNode varArgsMethod;
        IBoundNode accessorChain;
        IBoundNode arrayParametersMethod = this.makeArraParametersMethod(methodNode, bindingContext, methodName, argumentTypes, children);
        if (arrayParametersMethod != null) {
            String bindingType = ARRAY_ARGUMENT_METHOD;
            this.log(methodName, argumentTypes, bindingType);
            return arrayParametersMethod;
        }
        if (childrenCount == 2 && (accessorChain = new FieldAccessMethodBinder(methodName, children).bind(methodNode, bindingContext)) != null && !(accessorChain instanceof ErrorBoundNode)) {
            String bindingType = FIELD_ACCESS_METHOD;
            this.log(methodName, argumentTypes, bindingType);
            return accessorChain;
        }
        if (argumentTypes.length >= 1 && (varArgsMethod = new VariableLengthArgumentsMethodBinder(methodName, argumentTypes, children).bind(methodNode, bindingContext)) != null) {
            String bindingType = VARIABLE_NUMBER_OF_ARGUMENTS_METHOD;
            this.log(methodName, argumentTypes, bindingType);
            return varArgsMethod;
        }
        return this.cantFindMethodError(methodNode, bindingContext, methodName, argumentTypes);
    }

    private void log(String methodName, IOpenClass[] argumentTypes, String bindingType) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Method '{}' with parameters '{}' was binded as {}", new Object[]{methodName, this.getArgumentsAsString(argumentTypes), bindingType});
        }
    }

    private String getArgumentsAsString(IOpenClass[] argumentTypes) {
        String result = StringTool.arrayToStringThroughSymbol((Object[])argumentTypes, (String)",");
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return result;
        }
        return NO_PARAMETERS;
    }

    private IBoundNode cantFindMethodError(ISyntaxNode node, IBindingContext bindingContext, String methodName, IOpenClass[] parameterTypes) {
        String message = String.format("Method '%s' not found", MethodUtil.printMethod((String)methodName, (IOpenClass[])parameterTypes));
        BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
        return new ErrorBoundNode(node);
    }

    public IBoundNode bindTarget(ISyntaxNode node, IBindingContext bindingContext, IBoundNode target) throws Exception {
        IBoundNode[] children;
        IOpenClass[] types;
        int childrenCount = node.getNumberOfChildren();
        if (childrenCount < 1) {
            BindHelper.processError((String)"New node should have at least one subnode", (ISyntaxNode)node, (IBindingContext)bindingContext);
            return new ErrorBoundNode(node);
        }
        ISyntaxNode lastNode = node.getChild(childrenCount - 1);
        String methodName = ((IdentifierNode)lastNode).getIdentifier();
        IMethodCaller methodCaller = MethodSearch.getMethodCaller((String)methodName, (IOpenClass[])(types = MethodNodeBinder.getTypes((IBoundNode[])(children = MethodNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext, (int)0, (int)(childrenCount - 1))))), (ICastFactory)bindingContext, (IMethodFactory)target.getType());
        if (methodCaller == null) {
            StringBuilder buf = new StringBuilder("Method ");
            MethodUtil.printMethod((String)methodName, (IOpenClass[])types, (StringBuilder)buf);
            buf.append(" not found in '" + target.getType().getName() + "'");
            BindHelper.processError((String)buf.toString(), (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        if (target.isStaticTarget() != methodCaller.getMethod().isStatic()) {
            if (methodCaller.getMethod().isStatic()) {
                BindHelper.processWarn((String)"Access of a static method from non-static object", (ISyntaxNode)node, (IBindingContext)bindingContext);
            } else {
                BindHelper.processError((String)"Access of a non-static method from a static object", (ISyntaxNode)node, (IBindingContext)bindingContext);
                return new ErrorBoundNode(node);
            }
        }
        MethodBoundNode result = new MethodBoundNode(node, children, methodCaller, target);
        result.setTargetNode(target);
        return result;
    }
}

