/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.ArrayList;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.ArrayBoundNode;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class NewArrayNodeBinder
extends ANodeBinder {
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        int childrenCount = node.getNumberOfChildren();
        if (childrenCount != 1) {
            BindHelper.processError((String)"New array node must have 1 subnode", (ISyntaxNode)node, (IBindingContext)bindingContext);
            return new ErrorBoundNode(node);
        }
        ISyntaxNode indexChild = node.getChild(0);
        int dimension = 0;
        if (this.isArrayWithInitialization(node)) {
            indexChild = indexChild.getChild(0);
            while (indexChild.getType().equals("type.index")) {
                ++dimension;
                indexChild = indexChild.getChild(0);
            }
        }
        while (indexChild.getType().equals("array.index.empty")) {
            ++dimension;
            indexChild = indexChild.getChild(0);
        }
        ArrayList<ISyntaxNode> expressions = new ArrayList<ISyntaxNode>();
        while (indexChild.getType().equals("array.index.expression")) {
            expressions.add(indexChild.getChild(1));
            indexChild = indexChild.getChild(0);
        }
        int exprsize = expressions.size();
        IBoundNode[] exprAry = new IBoundNode[exprsize];
        for (int i = 0; i < exprAry.length; ++i) {
            exprAry[exprsize - i - 1] = NewArrayNodeBinder.bindTypeNode((ISyntaxNode)((ISyntaxNode)expressions.get(i)), (IBindingContext)bindingContext, (IOpenClass)JavaOpenClass.INT);
        }
        ISyntaxNode typeNode = indexChild;
        String typeName = ((IdentifierNode)typeNode).getIdentifier();
        IOpenClass componentType = bindingContext.findType("org.openl.this", typeName);
        if (componentType == null) {
            String message = String.format("Type '%s' not found", typeName);
            BindHelper.processError((String)message, (ISyntaxNode)typeNode, (IBindingContext)bindingContext);
            return new ErrorBoundNode(node);
        }
        IAggregateInfo info = componentType.getAggregateInfo();
        IOpenClass arrayType = info.getIndexedAggregateType(componentType, dimension + exprsize);
        if (this.isArrayWithInitialization(node)) {
            return NewArrayNodeBinder.bindTypeNode((ISyntaxNode)node.getChild(0).getChild(1), (IBindingContext)bindingContext, (IOpenClass)arrayType);
        }
        return new ArrayBoundNode(node, exprAry, dimension, arrayType, componentType);
    }

    private boolean isArrayWithInitialization(ISyntaxNode node) {
        return node.getChild(0).getType().equals("new.array.initialized");
    }
}

