/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.Iterator;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ILocalVar;
import org.openl.binding.impl.ABoundNode;
import org.openl.binding.impl.BaseAggregateIndexNodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.util.BooleanUtils;
import org.openl.vm.IRuntimeEnv;

public class SelectFirstIndexNodeBinder
extends BaseAggregateIndexNodeBinder {
    private static final String TEMPORARY_VAR_NAME = "selectFirstIndex";

    @Override
    public String getDefaultTempVarName(IBindingContext bindingContext) {
        return BindHelper.getTemporaryVarName((IBindingContext)bindingContext, (String)"org.openl.this", (String)TEMPORARY_VAR_NAME);
    }

    @Override
    protected IBoundNode createBoundNode(ISyntaxNode node, IBoundNode targetNode, IBoundNode expressionNode, ILocalVar localVar) {
        return new ConditionalSelectIndexNode(node, new IBoundNode[]{targetNode, expressionNode}, localVar);
    }

    @Override
    protected IBoundNode validateExpressionNode(IBoundNode expressionNode, IBindingContext bindingContext) {
        return BindHelper.checkConditionBoundNode((IBoundNode)expressionNode, (IBindingContext)bindingContext);
    }

    private static class ConditionalSelectIndexNode
    extends ABoundNode {
        private ILocalVar tempVar;

        public ConditionalSelectIndexNode(ISyntaxNode syntaxNode, IBoundNode[] children, ILocalVar tempVar) {
            super(syntaxNode, children);
            this.tempVar = tempVar;
        }

        public Object evaluateRuntime(IRuntimeEnv env) throws OpenLRuntimeException {
            IBoundNode container = this.getContainer();
            IBoundNode condition = this.getChildren()[1];
            IAggregateInfo aggregateInfo = this.getContainer().getType().getAggregateInfo();
            Iterator elementsIterator = aggregateInfo.getIterator(container.evaluate(env));
            while (elementsIterator.hasNext()) {
                Object element = elementsIterator.next();
                this.tempVar.set(null, element, env);
                if (!BooleanUtils.toBoolean((Object)condition.evaluate(env))) continue;
                return element;
            }
            return null;
        }

        private IBoundNode getContainer() {
            return this.getChildren()[0];
        }

        public IOpenClass getType() {
            IOpenClass type = this.getContainer().getType();
            return type.getAggregateInfo().getComponentType(type);
        }
    }
}

