/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.CastNode;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;

public class TypeCastBinder
extends ANodeBinder {
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        IBoundNode[] children = TypeCastBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext);
        IOpenClass to = children[0].getType();
        IOpenClass from = children[1].getType();
        if (from == NullOpenClass.the || to == NullOpenClass.the) {
            IBoundNode nullNode = to == NullOpenClass.the ? children[0] : children[1];
            String code = ((IdentifierNode)nullNode.getSyntaxNode().getChild(0)).getIdentifier();
            String message = String.format("Type '%s' not found", code);
            BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        if (to.equals(from)) {
            return children[1];
        }
        IOpenCast cast = bindingContext.getCast(from, to);
        if (cast == null) {
            if (!NullOpenClass.isAnyNull((IOpenClass[])new IOpenClass[]{from, to})) {
                String message = String.format("Can not convert from '%s' to '%s'", from.getName(), to.getName());
                BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            }
            return new ErrorBoundNode(node);
        }
        return new CastNode(node, children[1], cast, to);
    }
}

