/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMethodFactory;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.MethodSearch;
import org.openl.binding.impl.UnaryOpNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;

public class UnaryOperatorNodeBinder
extends ANodeBinder {
    public static String errorMsg(String methodName, IOpenClass t1) {
        return "Operator not defined: " + methodName + "(" + t1.getName() + ")";
    }

    public static IMethodCaller findUnaryOperatorMethodCaller(String methodName, IOpenClass[] types, IBindingContext bindingContext) {
        IMethodCaller methodCaller = bindingContext.findMethodCaller("org.openl.operators", methodName, types);
        if (methodCaller != null) {
            return methodCaller;
        }
        methodCaller = MethodSearch.getMethodCaller((String)methodName, (IOpenClass[])IOpenClass.EMPTY, (ICastFactory)bindingContext, (IMethodFactory)types[0]);
        if (methodCaller != null) {
            return methodCaller;
        }
        methodCaller = MethodSearch.getMethodCaller((String)methodName, (IOpenClass[])types, (ICastFactory)bindingContext, (IMethodFactory)types[0]);
        return methodCaller;
    }

    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        IBoundNode[] children;
        IOpenClass[] types;
        if (node.getNumberOfChildren() != 1) {
            BindHelper.processError((String)"Unary node should have 1 subnode", (ISyntaxNode)node, (IBindingContext)bindingContext);
            return new ErrorBoundNode(node);
        }
        int index = node.getType().lastIndexOf(46);
        String methodName = node.getType().substring(index + 1);
        IMethodCaller methodCaller = UnaryOperatorNodeBinder.findUnaryOperatorMethodCaller(methodName, types = UnaryOperatorNodeBinder.getTypes((IBoundNode[])(children = UnaryOperatorNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext))), bindingContext);
        if (methodCaller == null) {
            String message = UnaryOperatorNodeBinder.errorMsg(methodName, types[0]);
            BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext);
            return new ErrorBoundNode(node);
        }
        return new UnaryOpNode(node, children, methodCaller);
    }
}

