/*
 * Decompiled with CFR 0.152.
 */
package org.openl.spring.env;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.openl.spring.env.ConfigLog;
import org.openl.spring.env.DynamicPropertySource;
import org.openl.util.CollectionUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePropertySource;

public class ApplicationPropertySource
extends EnumerablePropertySource<Deque<PropertySource<?>>> {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationPropertySource.class);
    public static final String PROPS_NAME = "OpenL application properties";
    private static final String APP_NAME_TAG = "{appName}";
    private static final String PROFILE_TAG = "{profile}";
    private final String appName;
    private final String[] profiles;
    private final PropertyResolver resolver;
    private final LinkedList<EnumerablePropertySource> source = new LinkedList();
    private final LinkedList<EnumerablePropertySource<?>> profiledSource = new LinkedList();

    ApplicationPropertySource(PropertyResolver resolver, String appName, String ... profiles) {
        super(PROPS_NAME, new LinkedList());
        this.resolver = resolver;
        this.appName = appName;
        this.profiles = profiles;
        this.addLocations();
    }

    private static Object getInfo(Resource resource) {
        try {
            return resource.getURL();
        }
        catch (Exception e) {
            LOG.debug("Ignored error: ", (Throwable)e);
            return resource;
        }
    }

    private void addLocations() {
        String[] lc = this.resolvePlaceholders("${openl.config.location}");
        String[] nm = this.resolvePlaceholders("${openl.config.name}");
        for (String location : lc) {
            if (location.endsWith("/") || location.endsWith("\\") || location.endsWith(":")) {
                for (String name : nm) {
                    this.addLocation(location + name);
                }
                continue;
            }
            this.addLocation(location);
        }
    }

    private String[] resolvePlaceholders(String value) {
        String resolved = this.resolver.resolvePlaceholders(value);
        if (StringUtils.isBlank((CharSequence)resolved)) {
            ConfigLog.LOG.debug("!       Empty: '{}'", (Object)value);
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        return StringUtils.split((String)resolved, (char)',');
    }

    private void addLocation(String location) {
        if (location.contains(APP_NAME_TAG)) {
            if (StringUtils.isBlank((CharSequence)this.appName)) {
                ConfigLog.LOG.debug("- No app name: '{}'", (Object)location);
            } else {
                location = location.replace(APP_NAME_TAG, this.appName);
                this.addLocation(location, true);
            }
        } else {
            this.addLocation(location, false);
        }
    }

    private void addLocation(String location, boolean appNameResolved) {
        if (location.contains(PROFILE_TAG)) {
            if (CollectionUtils.isEmpty((Object[])this.profiles)) {
                ConfigLog.LOG.debug("- No profiles: '{}'", (Object)location);
            } else {
                for (String profile : this.profiles) {
                    this.addLocation(location.replace(PROFILE_TAG, profile), appNameResolved, true);
                }
            }
        } else {
            this.addLocation(location, appNameResolved, false);
        }
    }

    private void addLocation(String location, boolean appNameResolved, boolean isProfiled) {
        Object[] resources;
        try {
            resources = new PathMatchingResourcePatternResolver().getResources(location);
        }
        catch (IOException e) {
            ConfigLog.LOG.debug("!     Error: '{}'", new Object[]{location, e});
            return;
        }
        if (CollectionUtils.isEmpty((Object[])resources)) {
            ConfigLog.LOG.debug("- Not found: [{}]", (Object)location);
            return;
        }
        Arrays.sort(resources, Comparator.comparing(Resource::getFilename, Comparator.comparingInt(String::length).thenComparing(Comparator.naturalOrder())));
        for (Object resource : resources) {
            try {
                if (resource.exists()) {
                    ResourcePropertySource propertySource = appNameResolved || StringUtils.isBlank((CharSequence)this.appName) ? new ResourcePropertySource((Resource)resource) : new ResourcePropertySource((Resource)resource){

                        public Object getProperty(String name) {
                            Object property = super.getProperty(ApplicationPropertySource.this.appName + "." + name);
                            return property != null ? property : super.getProperty(name);
                        }
                    };
                    if (isProfiled) {
                        this.profiledSource.addFirst((EnumerablePropertySource<?>)propertySource);
                    } else {
                        this.source.addFirst((EnumerablePropertySource)propertySource);
                    }
                    ConfigLog.LOG.info("+       Load: [{}] '{}'", (Object)location, ApplicationPropertySource.getInfo((Resource)resource));
                    continue;
                }
                ConfigLog.LOG.debug("- Not exist: [{}] '{}'", (Object)location, ApplicationPropertySource.getInfo((Resource)resource));
            }
            catch (Exception ex) {
                ConfigLog.LOG.debug("!     Error: [{}] '{}'", new Object[]{location, ApplicationPropertySource.getInfo((Resource)resource), ex});
            }
        }
    }

    public Object getProperty(String name) {
        Object propertyInternal = this.getPropertyInternal(name);
        if (propertyInternal != null) {
            String value = propertyInternal.toString();
            value = StringUtils.trimToEmpty((String)value);
            return DynamicPropertySource.decode(value);
        }
        return propertyInternal;
    }

    private Object getPropertyInternal(String name) {
        Object candidate;
        for (PropertySource propertySource : this.profiledSource) {
            candidate = propertySource.getProperty(name);
            if (candidate == null) continue;
            return candidate;
        }
        for (PropertySource propertySource : this.source) {
            candidate = propertySource.getProperty(name);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    public boolean containsProperty(String name) {
        for (PropertySource propertySource : this.profiledSource) {
            if (!propertySource.containsProperty(name)) continue;
            return true;
        }
        for (PropertySource propertySource : this.source) {
            if (!propertySource.containsProperty(name)) continue;
            return true;
        }
        return false;
    }

    public String[] getPropertyNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (EnumerablePropertySource enumerablePropertySource : this.profiledSource) {
            names.addAll(Arrays.asList(enumerablePropertySource.getPropertyNames()));
        }
        for (EnumerablePropertySource enumerablePropertySource : this.source) {
            names.addAll(Arrays.asList(enumerablePropertySource.getPropertyNames()));
        }
        return names.toArray(new String[0]);
    }
}

