/*
 * Decompiled with CFR 0.152.
 */
package org.openl.spring.env;

import org.openl.spring.env.ConfigLog;
import org.openl.spring.env.DefaultPropertySource;
import org.openl.spring.env.RefPropertySource;
import org.openl.spring.env.SysInfoPropertySource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;

public class DefaultPropertyLoader
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
BeanFactoryPostProcessor,
EnvironmentAware,
PriorityOrdered {
    private Environment environment;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        this.initialize(environment);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.initialize((ConfigurableEnvironment)this.environment);
    }

    private void initialize(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = environment.getPropertySources();
        if (!propertySources.contains("OpenL default properties")) {
            ConfigLog.LOG.info("Loading default properties...");
            propertySources.addLast((PropertySource)new DefaultPropertySource());
            ConfigLog.LOG.info("Loading OpenL System Info properties...");
            propertySources.addFirst((PropertySource)new SysInfoPropertySource());
            ConfigLog.LOG.info("Register reference property processor...");
            propertySources.addLast((PropertySource)new RefPropertySource((PropertySources)propertySources));
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public int getOrder() {
        return 0;
    }
}

