/*
 * Decompiled with CFR 0.152.
 */
package org.openl.spring.env;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.openl.spring.env.ConfigLog;
import org.openl.util.StringUtils;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.ClassUtils;

public class DefaultPropertySource
extends EnumerablePropertySource<Map<String, String>> {
    public static final String PROPS_NAME = "OpenL default properties";
    static final String OPENL_CONFIG_LOADED = "openl.config.loaded";

    DefaultPropertySource() {
        super(PROPS_NAME, new HashMap());
        Properties prop = new Properties();
        try {
            ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
            if (classLoader == null) {
                classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            Enumeration<URL> resources = classLoader.getResources("openl-default.properties");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try (InputStream is = url.openStream();){
                    prop.load(is);
                }
                ConfigLog.LOG.info("+       Load: '{}'", (Object)url);
            }
        }
        catch (Exception e) {
            ConfigLog.LOG.error("!     Error:", (Throwable)e);
        }
        ((Map)this.source).putAll(new HashMap<Object, Object>(prop));
        ((Map)this.source).put(OPENL_CONFIG_LOADED, Boolean.TRUE.toString());
    }

    public String[] getPropertyNames() {
        Set propertyNames = ((Map)this.source).keySet();
        return propertyNames.toArray(StringUtils.EMPTY_STRING_ARRAY);
    }

    public Object getProperty(String name) {
        return ((Map)this.source).get(name);
    }
}

