/*
 * Decompiled with CFR 0.152.
 */
package org.openl.spring.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openl.info.OpenLVersion;
import org.openl.spring.env.ConfigLog;
import org.openl.spring.env.PassCoder;
import org.openl.spring.env.PreferencePropertySource;
import org.openl.spring.env.RawPropertyResolver;
import org.openl.util.FileUtils;
import org.openl.util.StringUtils;
import org.springframework.core.env.EnumerablePropertySource;

public class DynamicPropertySource
extends EnumerablePropertySource<Object> {
    public static final String PROPS_NAME = "Dynamic properties";
    public static final String OPENL_HOME = "openl.home";
    public static final String OPENL_HOME_SHARED = "openl.home.shared";
    private static final String PROP_VERSION = ".version";
    private final RawPropertyResolver resolver;
    private final String appName;
    private volatile Properties settings;
    private volatile String version;
    private volatile long timestamp;
    static DynamicPropertySource THE;

    public DynamicPropertySource(String appName, RawPropertyResolver resolver) {
        super(PROPS_NAME);
        this.resolver = resolver;
        this.appName = appName;
        this.loadProperties();
    }

    public String[] getPropertyNames() {
        return this.settings.keySet().toArray(StringUtils.EMPTY_STRING_ARRAY);
    }

    public boolean containsProperty(String name) {
        return this.settings.containsKey(name);
    }

    public boolean reloadIfModified() {
        boolean modified;
        long l = this.getFile().lastModified();
        boolean bl = modified = l != this.timestamp;
        if (modified) {
            this.loadProperties();
        }
        return modified;
    }

    private synchronized void loadProperties() {
        File file = this.getFile();
        Properties properties = new Properties();
        long lastModified = file.lastModified();
        if (file.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                properties.load(reader);
                ConfigLog.LOG.info("+       Load: '{}'", (Object)this.getFile());
            }
            catch (IOException e) {
                ConfigLog.LOG.error("!     Error:", (Throwable)e);
            }
            this.version = properties.getProperty(PROP_VERSION);
        } else {
            this.version = OpenLVersion.getVersion();
        }
        this.settings = properties;
        this.timestamp = lastModified;
    }

    private File getFile() {
        String property = this.resolver.getProperty(OPENL_HOME_SHARED);
        return new File(property, this.appName + ".properties");
    }

    public Object getProperty(String name) {
        if (OPENL_HOME.equals(name) || OPENL_HOME_SHARED.equals(name)) {
            return null;
        }
        String property = this.settings.getProperty(name);
        if (property == null) {
            return null;
        }
        property = StringUtils.trimToEmpty((String)property);
        return DynamicPropertySource.decode(property);
    }

    public static DynamicPropertySource get() {
        return THE;
    }

    public String version() {
        return this.version;
    }

    public void setOpenLHomeDir(String workingDir) {
        Preferences node = (Preferences)PreferencePropertySource.THE.getSource();
        node.put(OPENL_HOME, workingDir);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ConfigLog.LOG.error("Cannot save preferences value", (Throwable)e);
        }
        this.loadProperties();
    }

    public synchronized void save(Map<String, String> config) throws IOException {
        File settingsFile;
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.settings);
        for (Map.Entry<String, String> pair : config.entrySet()) {
            String value;
            String propertyName;
            block20: {
                propertyName = pair.getKey();
                value = pair.getValue();
                if (value == null) {
                    properties.remove(propertyName);
                    continue;
                }
                if (propertyName.endsWith("password")) {
                    try {
                        String secretKey = this.getSecretKey();
                        String cipher = this.getCipher();
                        if (!StringUtils.isNotBlank((CharSequence)value) || !StringUtils.isNotBlank((CharSequence)secretKey) || !StringUtils.isNotBlank((CharSequence)cipher)) break block20;
                        value = "ENC(" + PassCoder.encode(value, secretKey, cipher) + ")";
                    }
                    catch (Exception e2) {
                        ConfigLog.LOG.error("Error when setting password property: {}", (Object)propertyName, (Object)e2);
                        continue;
                    }
                }
            }
            properties.setProperty(propertyName, value);
        }
        Properties origin = this.settings;
        this.settings = new Properties();
        properties.entrySet().removeIf(e -> Objects.equals(this.resolver.getRawProperty(e.getKey().toString()), e.getValue().toString()));
        properties.remove(PROP_VERSION);
        boolean noPropsToSave = properties.isEmpty();
        this.version = OpenLVersion.getVersion();
        this.settings = properties;
        if (noPropsToSave) {
            settingsFile = this.getFile();
            FileUtils.deleteQuietly((File)settingsFile);
            return;
        }
        properties.put(PROP_VERSION, OpenLVersion.getVersion());
        if (!origin.equals(properties)) {
            settingsFile = this.getFile();
            File parent = settingsFile.getParentFile();
            if (!parent.mkdirs() && !parent.exists()) {
                throw new FileNotFoundException("Can't create the folder " + parent.getAbsolutePath());
            }
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(settingsFile), StandardCharsets.UTF_8);){
                properties.store(writer, null);
            }
        }
    }

    static String decode(String value) {
        if (value != null && value.startsWith("ENC(") && value.endsWith(")")) {
            try {
                return PassCoder.decode(value.substring(4, value.length() - 1), DynamicPropertySource.get().getSecretKey(), DynamicPropertySource.get().getCipher());
            }
            catch (Exception e) {
                return "";
            }
        }
        return value;
    }

    public Properties getProperties() {
        return this.settings;
    }

    private String getSecretKey() {
        return StringUtils.trimToNull((String)this.resolver.getProperty("secret.key"));
    }

    private String getCipher() {
        return StringUtils.trimToNull((String)this.resolver.getProperty("secret.cipher"));
    }
}

