/*
 * Decompiled with CFR 0.152.
 */
package org.openl.spring.env;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.openl.spring.env.ApplicationPropertySource;
import org.openl.spring.env.ConfigLog;
import org.openl.spring.env.DefaultPropertySource;
import org.openl.spring.env.DisablePropertySource;
import org.openl.spring.env.DynamicPropertySource;
import org.openl.spring.env.PreferencePropertySource;
import org.openl.spring.env.PropertyBean;
import org.openl.spring.env.RawPropertyResolver;
import org.openl.spring.env.RefPropertySource;
import org.openl.spring.env.ServletContextPropertySource;
import org.openl.spring.env.SysInfoPropertySource;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.jndi.JndiLocatorDelegate;
import org.springframework.jndi.JndiPropertySource;

public class PropertySourcesLoader
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext appContext) {
        ConfigLog.LOG.info("The initialization of properties from 'contextInitializerClasses' context-param in web.xml");
        ConfigurableEnvironment env = appContext.getEnvironment();
        String appName = PropertySourcesLoader.normalizeAppName(appContext.getApplicationName());
        this.loadEnvironment(appContext, env, appName, null);
    }

    public void initialize(ConfigurableApplicationContext appContext, ServletContext servletContext) {
        ConfigLog.LOG.info("The initialization of properties");
        StandardEnvironment env = new StandardEnvironment();
        appContext.setEnvironment((ConfigurableEnvironment)env);
        String appName = PropertySourcesLoader.normalizeAppName(servletContext.getContextPath());
        this.loadEnvironment(appContext, (ConfigurableEnvironment)env, appName, servletContext);
    }

    private void loadEnvironment(ConfigurableApplicationContext appContext, ConfigurableEnvironment env, String appName, ServletContext servletContext) {
        DynamicPropertySource propertySource;
        PreferencePropertySource preferencePropertySource;
        MutablePropertySources propertySources = env.getPropertySources();
        RawPropertyResolver props = new RawPropertyResolver((PropertySources)propertySources);
        ConfigLog.LOG.info("Loading default properties...");
        DefaultPropertySource defaultPropertySource = new DefaultPropertySource();
        propertySources.addLast((PropertySource)defaultPropertySource);
        ConfigLog.LOG.info("Loading preference properties...");
        PreferencePropertySource.THE = preferencePropertySource = new PreferencePropertySource(appName);
        propertySources.addBefore("OpenL default properties", (PropertySource)preferencePropertySource);
        if (servletContext != null) {
            ConfigLog.LOG.info("Loading JNDI properties...");
            if (JndiLocatorDelegate.isDefaultJndiEnvironmentAvailable()) {
                propertySources.addFirst((PropertySource)new JndiPropertySource("JNDI properties"));
            }
            ConfigLog.LOG.info("Loading ServletContext init parameters...");
            propertySources.addFirst((PropertySource)new ServletContextPropertySource("ServletContext init parameters", servletContext));
        }
        ConfigLog.LOG.info("Loading application properties...");
        String[] profiles = env.getActiveProfiles();
        propertySources.addBefore("OpenL preference properties", (PropertySource)new ApplicationPropertySource((PropertyResolver)props, appName, profiles));
        ConfigLog.LOG.info("Loading OpenL System Info properties...");
        propertySources.addFirst((PropertySource)new SysInfoPropertySource());
        ConfigLog.LOG.info("Loading reconfigurable properties...");
        DynamicPropertySource.THE = propertySource = new DynamicPropertySource(appName, props);
        propertySources.addBefore("OpenL application properties", (PropertySource)propertySource);
        propertySources.addBefore("Dynamic properties", (PropertySource)new DisablePropertySource((PropertySources)propertySources));
        ConfigLog.LOG.info("Register reference property processor...");
        propertySources.addLast((PropertySource)new RefPropertySource((PropertySources)propertySources));
        this.registerPropertyBean(appContext, defaultPropertySource, props);
        ConfigLog.LOG.info("Loading of the properties has been finished.");
    }

    private void registerPropertyBean(ConfigurableApplicationContext appContext, DefaultPropertySource defaultPropertySource, RawPropertyResolver props) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String key : defaultPropertySource.getPropertyNames()) {
            propertyMap.put(key, props.getRawProperty(key));
        }
        appContext.addBeanFactoryPostProcessor(bf -> bf.registerSingleton("PropertyBean", (Object)new PropertyBean((Map)defaultPropertySource.getSource(), propertyMap)));
    }

    private static String normalizeAppName(String appName) {
        if (appName.isEmpty()) {
            return "";
        }
        return appName.replace('/', ' ').replace('\\', ' ').trim().replace(' ', '-');
    }
}

