/*
 * Decompiled with CFR 0.152.
 */
package org.openl.spring.env;

import java.util.Iterator;
import org.openl.util.StringUtils;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;

class RefPropertySource
extends PropertySource<Object> {
    static final String PROPS_NAME = "References to properties";
    private static final String REF = ".$ref";
    private final PropertySources propertySources;

    RefPropertySource(PropertySources propertySources) {
        super(PROPS_NAME);
        this.propertySources = propertySources;
    }

    public Object getProperty(String name) {
        if (name.endsWith(REF)) {
            return null;
        }
        String subName = name;
        StringBuilder sufix = new StringBuilder();
        int dot = name.length();
        do {
            sufix.insert(0, subName.substring(dot));
            subName = subName.substring(0, dot);
            String ref = subName + REF;
            String refProp = StringUtils.trimToNull((String)this.getPropValue(ref));
            if (refProp == null) continue;
            return this.getPropValue(refProp + sufix);
        } while ((dot = subName.lastIndexOf(46)) > 0);
        return null;
    }

    private String getPropValue(String ref) {
        PropertySource propertySource;
        Iterator iterator = this.propertySources.iterator();
        while (iterator.hasNext() && !(propertySource = (PropertySource)iterator.next()).getName().equals(PROPS_NAME)) {
            Object value = propertySource.getProperty(ref);
            if (value == null) continue;
            return value.toString();
        }
        return null;
    }
}

