/*
 * Decompiled with CFR 0.152.
 */
package openlr;

import java.util.ArrayList;
import openlr.location.GeoCoordLocation;
import openlr.location.LineLocation;
import openlr.location.LocationFactory;
import openlr.location.PoiAccessLocation;
import openlr.location.PointAlongLocation;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.location.utils.LocationData;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;
import openlr.map.Node;
import openlr.rawLocRef.RawGeoCoordLocRef;
import openlr.testutils.CommonObjectTestUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EqualsHashCodeToStringTest {
    private static Mockery mockery = new Mockery();
    private static final Line LINE_1 = EqualsHashCodeToStringTest.mockLine(1L);
    private static final Line LINE_MINUS_1 = EqualsHashCodeToStringTest.mockLine(-1L);
    private final GeoCoordinates geoCoordinate = new GeoCoordinatesImpl(180.0, -90.0);
    private final GeoCoordinates geoCoordinateEqual = new GeoCoordinatesImpl(180.0, -90.0);
    private final GeoCoordinates geoCoordinateUnEqual = new GeoCoordinatesImpl(180.0, 0.0);

    private static Line mockLine(final long id) {
        final Line result = (Line)mockery.mock(Line.class, "Line " + id);
        mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Line)this.allowing(result)).getID();
                this.will(1.returnValue((Object)id));
            }
        });
        mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Line)this.allowing(result)).getStartNode();
                this.will(2.returnValue((Object)EqualsHashCodeToStringTest.mockNode(id << 1)));
            }
        });
        mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Line)this.allowing(result)).getEndNode();
                this.will(3.returnValue((Object)EqualsHashCodeToStringTest.mockNode(id << 2)));
            }
        });
        mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Line)this.allowing(result)).getGeoCoordinateAlongLine(this.with(4.any(Integer.class)));
                this.will(4.returnValue((Object)GeoCoordinatesImpl.newGeoCoordinatesUnchecked((double)1.0, (double)1.0)));
            }
        });
        return result;
    }

    private static Node mockNode(final long id) {
        final Node result = (Node)mockery.mock(Node.class, "Node " + id);
        mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Node)this.allowing(result)).getID();
                this.will(5.returnValue((Object)id));
            }
        });
        mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Node)this.allowing(result)).getLongitudeDeg();
                this.will(6.returnValue((Object)0.0));
            }
        });
        mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Node)this.allowing(result)).getLatitudeDeg();
                this.will(7.returnValue((Object)1.0));
            }
        });
        mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Node)this.allowing(result)).getGeoCoordinates();
                this.will(8.returnValue((Object)GeoCoordinatesImpl.newGeoCoordinatesUnchecked((double)0.0, (double)1.0)));
            }
        });
        return result;
    }

    @Test
    public final void testGeoCoordLocation() {
        try {
            GeoCoordLocation geoL = (GeoCoordLocation)LocationFactory.createGeoCoordinateLocation((String)"id", (double)this.geoCoordinate.getLongitudeDeg(), (double)this.geoCoordinate.getLatitudeDeg());
            GeoCoordLocation geoLEqual = (GeoCoordLocation)LocationFactory.createGeoCoordinateLocation((String)"idEqual", (double)this.geoCoordinateEqual.getLongitudeDeg(), (double)this.geoCoordinateEqual.getLatitudeDeg());
            GeoCoordLocation geoLUnEqual = (GeoCoordLocation)LocationFactory.createGeoCoordinateLocation((String)"od", (double)180.0, (double)0.0);
            CommonObjectTestUtils.testCompare(geoL, geoLEqual, geoLUnEqual);
            CommonObjectTestUtils.testToString(geoL);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    @Test
    public final void testInterfaceImplementationObject() {
        CommonObjectTestUtils.testCompare(this.geoCoordinate, this.geoCoordinateEqual, this.geoCoordinateUnEqual);
    }

    @Test
    public final void testRawLocationReferenceObjects() {
        RawGeoCoordLocRef geoL = new RawGeoCoordLocRef("geo", this.geoCoordinate);
        RawGeoCoordLocRef geoLEqual = new RawGeoCoordLocRef("geoEq", this.geoCoordinateEqual);
        RawGeoCoordLocRef geoLUnEqual = new RawGeoCoordLocRef("geoUnequ", this.geoCoordinateUnEqual);
        CommonObjectTestUtils.testCompare(geoL, geoLEqual, geoLUnEqual);
        CommonObjectTestUtils.testToString(geoL);
    }

    @Test
    public final void testLineLocation() {
        ArrayList<Line> lines = new ArrayList<Line>(2);
        lines.add(LINE_1);
        lines.add(null);
        lines.add(LINE_MINUS_1);
        LineLocation lineLoc = (LineLocation)LocationFactory.createLineLocationWithOffsets((String)"id", lines, (int)1, (int)2);
        LineLocation lineLocEqual = (LineLocation)LocationFactory.createLineLocationWithOffsets((String)"id", lines, (int)1, (int)2);
        LineLocation lineLocUnequal = (LineLocation)LocationFactory.createLineLocationWithOffsets((String)"od", lines, (int)0, (int)2);
        CommonObjectTestUtils.testCompare(lineLoc, lineLocEqual, lineLocUnequal);
        CommonObjectTestUtils.testToString(lineLoc);
    }

    @Test
    public final void testPoiAccessLocation() {
        try {
            PoiAccessLocation poiLoc = (PoiAccessLocation)LocationFactory.createPoiAccessAtNodeLocationWithSideAndOrientation((String)"id", (Line)LINE_1, (double)-180.0, (double)90.0, (SideOfRoad)SideOfRoad.LEFT, (Orientation)Orientation.BOTH);
            PoiAccessLocation poiLocEqual = (PoiAccessLocation)LocationFactory.createPoiAccessAtNodeLocationWithSideAndOrientation((String)"id", (Line)LINE_1, (double)-180.0, (double)90.0, (SideOfRoad)SideOfRoad.LEFT, (Orientation)Orientation.BOTH);
            PoiAccessLocation poiLocUnEqual = (PoiAccessLocation)LocationFactory.createPoiAccessAtNodeLocationWithSideAndOrientation((String)"id", (Line)LINE_1, (double)180.0, (double)90.0, (SideOfRoad)SideOfRoad.RIGHT, (Orientation)Orientation.BOTH);
            CommonObjectTestUtils.testCompare(poiLoc, poiLocEqual, poiLocUnEqual);
            CommonObjectTestUtils.testToString(poiLoc);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    @Test
    public final void testPointAlongLocation() {
        try {
            PointAlongLocation palLoc = (PointAlongLocation)LocationFactory.createPointAlongLineLocationWithSideAndOrientation((String)"id", (Line)LINE_1, (int)1, (SideOfRoad)SideOfRoad.LEFT, (Orientation)Orientation.BOTH);
            PointAlongLocation palLocEqual = (PointAlongLocation)LocationFactory.createPointAlongLineLocationWithSideAndOrientation((String)"id", (Line)LINE_1, (int)1, (SideOfRoad)SideOfRoad.LEFT, (Orientation)Orientation.BOTH);
            PointAlongLocation palLocUnEqualLine = (PointAlongLocation)LocationFactory.createPointAlongLineLocationWithSideAndOrientation((String)"id", (Line)LINE_MINUS_1, (int)2, (SideOfRoad)SideOfRoad.LEFT, (Orientation)Orientation.BOTH);
            CommonObjectTestUtils.testCompare(palLoc, palLocEqual, palLocUnEqualLine);
            PointAlongLocation palLocUnEqualMember = (PointAlongLocation)LocationFactory.createPointAlongLineLocationWithSideAndOrientation((String)"id", (Line)LINE_1, (int)0, (SideOfRoad)SideOfRoad.LEFT, (Orientation)Orientation.BOTH);
            CommonObjectTestUtils.testCompare(palLoc, palLocEqual, palLocUnEqualMember);
            CommonObjectTestUtils.testToString(palLoc);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    @Test
    public final void testLocationData() {
        LocationData ld = new LocationData();
        CommonObjectTestUtils.testToString(ld);
    }
}

