/*
 * Decompiled with CFR 0.152.
 */
package openlr.location;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import openlr.LocationType;
import openlr.StatusCode;
import openlr.location.CircleLocation;
import openlr.location.ClosedLineLocation;
import openlr.location.GeoCoordLocation;
import openlr.location.GridLocation;
import openlr.location.InvalidLocation;
import openlr.location.LineLocation;
import openlr.location.Location;
import openlr.location.LocationFactory;
import openlr.location.PoiAccessLocation;
import openlr.location.PointAlongLocation;
import openlr.location.PolygonLocation;
import openlr.location.RectangleLocation;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.mockdb.InvalidConfigurationException;
import openlr.map.mockdb.MockedMapDatabase;
import openlr.map.utils.GeometryUtils;
import openlr.testutils.CommonObjectTestUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LocationTypesTest {
    public static final String DEFAULT_MAP_DB_CONFIG = "DefaultMapDatabase.xml";
    private static final int NEG_OFFSET = 30;
    private static final int POS_OFFSET = 20;
    private static final Point2D.Double GEO_COORDINATE = new Point2D.Double(6.12699, 49.60728);
    private static final MapDatabase MDB;
    private static final double COORDINATE_LATITUDE = 49.60728;
    private static final double COORDINATE_LONGITUDE = 6.12699;
    private static final long RADIUS_SMALL = 100L;
    private static final long RADIUS_MEDIUM = 60000L;
    private static final long RADIUS_LARGE = 16000000L;
    private static final long RADIUS_EXTRA_LARGE = 4000000000L;
    private static final int ROWS = 5;
    private static final int COLUMNS = 4;
    private static final GeoCoordinates RECTANGLE_LL;
    private static final GeoCoordinates RECTANGLE_UR;
    private static final List<GeoCoordinates> RECTANGLE_CORNERS;
    private static final List<GeoCoordinates> CORNERS;
    private static final GeoCoordinates SCALED_UR;
    private static final List<GeoCoordinates> SCALED_RECTANGLE_CORNERS;
    private static final List<Line> LINES_LINE_LOCATION;
    private static final Line POI_LOC_LINE;
    private static final Point2D.Double POI;
    private static final Point2D.Double POI2;
    private static final GeoCoordLocation geoLoc;
    private static final PoiAccessLocation poiLoc;
    private static final PoiAccessLocation poiLocAtNode;
    private static final PointAlongLocation palLoc;
    private static final PointAlongLocation palLocAtNode;
    private static final CircleLocation circleSmall;
    private static final CircleLocation circleMedium;
    private static final CircleLocation circleLarge;
    private static final CircleLocation circleExtraLarge;
    private static final RectangleLocation rectangle;
    private static final GridLocation gridBasis;
    private static final GridLocation gridArea;
    private static final PolygonLocation polygon;
    private static final ClosedLineLocation closedLine;
    private LineLocation lineLocOff = (LineLocation)LocationFactory.createLineLocationWithOffsets((String)"liLoOff", LINES_LINE_LOCATION, (int)20, (int)30);
    private LineLocation lineLocNoOff = (LineLocation)LocationFactory.createLineLocation((String)"liLoNoOff", LINES_LINE_LOCATION);

    @Test
    public final void testGeoLocation() {
        Assert.assertNull((Object)geoLoc.getLocationLines());
        Assert.assertFalse((boolean)geoLoc.hasNegativeOffset());
        Assert.assertFalse((boolean)geoLoc.hasPositiveOffset());
        Assert.assertTrue((geoLoc.getNegativeOffset() <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((geoLoc.getPositiveOffset() <= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)geoLoc.getPoiLine());
        Assert.assertNull((Object)geoLoc.getSideOfRoad());
        Assert.assertNull((Object)geoLoc.getOrientation());
        Assert.assertNull((Object)geoLoc.getAccessPoint());
        Assert.assertEquals((double)geoLoc.getPointLocation().getLongitudeDeg(), (double)LocationTypesTest.GEO_COORDINATE.x);
        Assert.assertEquals((double)geoLoc.getPointLocation().getLatitudeDeg(), (double)LocationTypesTest.GEO_COORDINATE.y);
        Assert.assertTrue((boolean)geoLoc.isValid());
        Assert.assertNull((Object)geoLoc.getReturnCode());
        Assert.assertNotNull((Object)geoLoc.toString());
    }

    @Test
    public final void testPoiWithAccessLocation() {
        PoiAccessLocation[] toCheck;
        for (PoiAccessLocation loc : toCheck = new PoiAccessLocation[]{poiLoc, poiLocAtNode}) {
            String message = "Failed assertion while checking location: \"" + loc.getID() + "\"";
            Assert.assertNull((Object)loc.getLocationLines(), (String)message);
            Assert.assertFalse((boolean)loc.hasNegativeOffset(), (String)message);
            Assert.assertTrue((loc.getNegativeOffset() <= 0 ? 1 : 0) != 0, (String)message);
            Assert.assertEquals((long)loc.getPoiLine().getID(), (long)POI_LOC_LINE.getID(), (String)message);
            Assert.assertNotNull((Object)poiLoc.getAccessPoint(), (String)message);
            Assert.assertEquals((double)loc.getPointLocation().getLongitudeDeg(), (double)LocationTypesTest.POI.x, (String)message);
            Assert.assertEquals((double)loc.getPointLocation().getLatitudeDeg(), (double)LocationTypesTest.POI.y, (String)message);
            Assert.assertTrue((boolean)loc.isValid());
            Assert.assertNull((Object)loc.getReturnCode());
            Assert.assertNotNull((Object)loc.toString());
        }
        Assert.assertTrue((boolean)poiLoc.hasPositiveOffset());
        Assert.assertEquals((int)poiLoc.getPositiveOffset(), (int)20);
        Assert.assertEquals((Object)poiLoc.getSideOfRoad(), (Object)SideOfRoad.LEFT);
        Assert.assertEquals((Object)poiLoc.getOrientation(), (Object)Orientation.BOTH);
        Assert.assertFalse((boolean)poiLocAtNode.hasPositiveOffset());
        Assert.assertTrue((poiLocAtNode.getPositiveOffset() <= 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)poiLocAtNode.getSideOfRoad(), (Object)SideOfRoad.RIGHT);
        Assert.assertEquals((Object)poiLocAtNode.getOrientation(), (Object)Orientation.WITH_LINE_DIRECTION);
    }

    @Test
    public final void testPointAlongLocation() {
        PointAlongLocation[] toCheck;
        for (PointAlongLocation loc : toCheck = new PointAlongLocation[]{palLoc, palLocAtNode}) {
            String message = "Failed assertion while checking location: \"" + loc.getID() + "\"";
            Assert.assertNull((Object)loc.getLocationLines(), (String)message);
            Assert.assertFalse((boolean)loc.hasNegativeOffset(), (String)message);
            Assert.assertTrue((loc.getNegativeOffset() <= 0 ? 1 : 0) != 0, (String)message);
            Assert.assertEquals((long)loc.getPoiLine().getID(), (long)POI_LOC_LINE.getID(), (String)message);
            Assert.assertNotNull((Object)poiLoc.getAccessPoint(), (String)message);
            Assert.assertNull((Object)loc.getPointLocation(), (String)message);
            Assert.assertTrue((boolean)loc.isValid());
            Assert.assertNull((Object)loc.getReturnCode());
            Assert.assertNotNull((Object)loc.toString());
        }
        Assert.assertTrue((boolean)palLoc.hasPositiveOffset());
        Assert.assertEquals((int)palLoc.getPositiveOffset(), (int)20);
        Assert.assertEquals((Object)palLoc.getSideOfRoad(), (Object)SideOfRoad.LEFT);
        Assert.assertEquals((Object)palLoc.getOrientation(), (Object)Orientation.BOTH);
        Assert.assertFalse((boolean)palLocAtNode.hasPositiveOffset());
        Assert.assertTrue((palLocAtNode.getPositiveOffset() <= 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)palLocAtNode.getSideOfRoad(), (Object)SideOfRoad.getDefault());
        Assert.assertEquals((Object)palLocAtNode.getOrientation(), (Object)Orientation.getDefault());
    }

    @Test
    public final void testLineLocation() {
        LineLocation[] toCheck;
        for (LineLocation loc : toCheck = new LineLocation[]{this.lineLocNoOff, this.lineLocOff}) {
            String message = "Failed assertion while checking location: \"" + loc.getID() + "\"";
            int i = 0;
            for (Line line : loc.getLocationLines()) {
                Assert.assertEquals((long)line.getID(), (long)LINES_LINE_LOCATION.get(i++).getID());
            }
            Assert.assertNull((Object)loc.getPoiLine(), (String)message);
            Assert.assertNull((Object)loc.getSideOfRoad(), (String)message);
            Assert.assertNull((Object)loc.getOrientation(), (String)message);
            Assert.assertNull((Object)loc.getAccessPoint(), (String)message);
            Assert.assertNull((Object)loc.getPointLocation(), (String)message);
            Assert.assertTrue((boolean)loc.isValid());
            Assert.assertNull((Object)loc.getReturnCode());
            Assert.assertNotNull((Object)loc.toString(), (String)message);
        }
        Assert.assertTrue((boolean)this.lineLocOff.hasNegativeOffset());
        Assert.assertTrue((boolean)this.lineLocOff.hasPositiveOffset());
        Assert.assertEquals((int)this.lineLocOff.getNegativeOffset(), (int)30);
        Assert.assertEquals((int)this.lineLocOff.getPositiveOffset(), (int)20);
        Assert.assertFalse((boolean)this.lineLocNoOff.hasNegativeOffset());
        Assert.assertFalse((boolean)this.lineLocNoOff.hasPositiveOffset());
        Assert.assertTrue((this.lineLocNoOff.getNegativeOffset() <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.lineLocNoOff.getPositiveOffset() <= 0 ? 1 : 0) != 0);
    }

    @Test
    public final void testCircleLocation() {
        ArrayList<CircleLocation> circles = new ArrayList<CircleLocation>();
        circles.add(circleSmall);
        circles.add(circleMedium);
        circles.add(circleLarge);
        circles.add(circleExtraLarge);
        for (CircleLocation c : circles) {
            Assert.assertNotNull((Object)c.getID());
            Assert.assertNull((Object)c.getAccessPoint());
            Assert.assertNull((Object)c.getAffectedLines());
            Assert.assertNotNull((Object)c.getCenterPoint());
            Assert.assertEquals((double)c.getCenterPoint().getLongitudeDeg(), (double)6.12699);
            Assert.assertEquals((double)c.getCenterPoint().getLatitudeDeg(), (double)49.60728);
            Assert.assertNull((Object)c.getCornerPoints());
            Assert.assertNull((Object)c.getLocationLines());
            Assert.assertEquals((Object)c.getLocationType(), (Object)LocationType.CIRCLE);
            Assert.assertNull((Object)c.getLowerLeftPoint());
            Assert.assertTrue((c.getNegativeOffset() <= 0 ? 1 : 0) != 0);
            Assert.assertEquals((int)c.getNumberOfColumns(), (int)-1);
            Assert.assertEquals((int)c.getNumberOfRows(), (int)-1);
            Assert.assertNull((Object)c.getOrientation());
            Assert.assertNull((Object)c.getPoiLine());
            Assert.assertNull((Object)c.getPointLocation());
            Assert.assertNull((Object)c.getReturnCode());
            Assert.assertTrue((c.getPositiveOffset() <= 0 ? 1 : 0) != 0);
            Assert.assertNull((Object)c.getSideOfRoad());
            Assert.assertNull((Object)c.getUpperRightPoint());
            Assert.assertTrue((boolean)c.isValid());
            Assert.assertFalse((boolean)c.hasNegativeOffset());
            Assert.assertFalse((boolean)c.hasPositiveOffset());
        }
        Assert.assertEquals((long)circleSmall.getRadius(), (long)100L);
        Assert.assertEquals((long)circleMedium.getRadius(), (long)60000L);
        Assert.assertEquals((long)circleLarge.getRadius(), (long)16000000L);
        Assert.assertEquals((long)circleExtraLarge.getRadius(), (long)4000000000L);
    }

    @Test
    public final void testRectangle() {
        Assert.assertNotNull((Object)rectangle.getID());
        Assert.assertNull((Object)rectangle.getAccessPoint());
        Assert.assertNull((Object)rectangle.getAffectedLines());
        Assert.assertNull((Object)rectangle.getCenterPoint());
        Assert.assertNotNull((Object)rectangle.getCornerPoints());
        Assert.assertEquals((int)rectangle.getCornerPoints().size(), (int)RECTANGLE_CORNERS.size());
        for (int i = 0; i < RECTANGLE_CORNERS.size(); ++i) {
            Assert.assertEquals(rectangle.getCornerPoints().get(i), (Object)RECTANGLE_CORNERS.get(i));
        }
        Assert.assertNull((Object)rectangle.getLocationLines());
        Assert.assertEquals((Object)rectangle.getLocationType(), (Object)LocationType.RECTANGLE);
        Assert.assertNotNull((Object)rectangle.getLowerLeftPoint());
        Assert.assertEquals((Object)rectangle.getLowerLeftPoint(), (Object)RECTANGLE_LL);
        Assert.assertTrue((rectangle.getNegativeOffset() <= 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)rectangle.getNumberOfColumns(), (int)-1);
        Assert.assertEquals((int)rectangle.getNumberOfRows(), (int)-1);
        Assert.assertNull((Object)rectangle.getOrientation());
        Assert.assertNull((Object)rectangle.getPoiLine());
        Assert.assertNull((Object)rectangle.getPointLocation());
        Assert.assertNull((Object)rectangle.getReturnCode());
        Assert.assertTrue((rectangle.getPositiveOffset() <= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)rectangle.getSideOfRoad());
        Assert.assertNotNull((Object)rectangle.getUpperRightPoint());
        Assert.assertEquals((Object)rectangle.getUpperRightPoint(), (Object)RECTANGLE_UR);
        Assert.assertTrue((boolean)rectangle.isValid());
        Assert.assertFalse((boolean)rectangle.hasNegativeOffset());
        Assert.assertFalse((boolean)rectangle.hasPositiveOffset());
        Assert.assertEquals((long)rectangle.getRadius(), (long)-1L);
    }

    @Test
    public final void testGrid() {
        int i;
        ArrayList<GridLocation> grids = new ArrayList<GridLocation>();
        grids.add(gridArea);
        grids.add(gridBasis);
        for (GridLocation loc : grids) {
            Assert.assertNotNull((Object)loc.getID());
            Assert.assertNull((Object)loc.getAccessPoint());
            Assert.assertNull((Object)loc.getAffectedLines());
            Assert.assertNull((Object)loc.getCenterPoint());
            Assert.assertNotNull((Object)loc.getCornerPoints());
            Assert.assertNull((Object)loc.getLocationLines());
            Assert.assertEquals((Object)loc.getLocationType(), (Object)LocationType.GRID);
            Assert.assertNotNull((Object)loc.getLowerLeftPoint());
            Assert.assertEquals((Object)loc.getLowerLeftPoint(), (Object)RECTANGLE_LL);
            Assert.assertTrue((loc.getNegativeOffset() <= 0 ? 1 : 0) != 0);
            Assert.assertEquals((int)loc.getNumberOfColumns(), (int)4);
            Assert.assertEquals((int)loc.getNumberOfRows(), (int)5);
            Assert.assertNull((Object)loc.getOrientation());
            Assert.assertNull((Object)loc.getPoiLine());
            Assert.assertNull((Object)loc.getPointLocation());
            Assert.assertNull((Object)loc.getReturnCode());
            Assert.assertTrue((loc.getPositiveOffset() <= 0 ? 1 : 0) != 0);
            Assert.assertNull((Object)loc.getSideOfRoad());
            Assert.assertNotNull((Object)loc.getUpperRightPoint());
            Assert.assertTrue((boolean)loc.isValid());
            Assert.assertFalse((boolean)loc.hasNegativeOffset());
            Assert.assertFalse((boolean)loc.hasPositiveOffset());
        }
        Assert.assertEquals((Object)gridBasis.getUpperRightPoint(), (Object)RECTANGLE_UR);
        Assert.assertEquals((int)gridBasis.getCornerPoints().size(), (int)RECTANGLE_CORNERS.size());
        for (i = 0; i < RECTANGLE_CORNERS.size(); ++i) {
            Assert.assertEquals(gridBasis.getCornerPoints().get(i), (Object)RECTANGLE_CORNERS.get(i));
        }
        Assert.assertEquals((double)GeometryUtils.round((double)gridArea.getUpperRightPoint().getLongitudeDeg()), (double)SCALED_UR.getLongitudeDeg());
        Assert.assertEquals((double)GeometryUtils.round((double)gridArea.getUpperRightPoint().getLatitudeDeg()), (double)SCALED_UR.getLatitudeDeg());
        Assert.assertEquals((int)gridArea.getCornerPoints().size(), (int)SCALED_RECTANGLE_CORNERS.size());
        for (i = 0; i < SCALED_RECTANGLE_CORNERS.size(); ++i) {
            Assert.assertEquals((double)GeometryUtils.round((double)((GeoCoordinates)gridArea.getCornerPoints().get(i)).getLongitudeDeg()), (double)SCALED_RECTANGLE_CORNERS.get(i).getLongitudeDeg());
            Assert.assertEquals((double)GeometryUtils.round((double)((GeoCoordinates)gridArea.getCornerPoints().get(i)).getLatitudeDeg()), (double)SCALED_RECTANGLE_CORNERS.get(i).getLatitudeDeg());
        }
    }

    @Test
    public final void testPolygon() {
        Assert.assertNotNull((Object)polygon.getID());
        Assert.assertNull((Object)polygon.getAccessPoint());
        Assert.assertNull((Object)polygon.getAffectedLines());
        Assert.assertNull((Object)polygon.getCenterPoint());
        Assert.assertNotNull((Object)polygon.getCornerPoints());
        Assert.assertEquals((int)polygon.getCornerPoints().size(), (int)CORNERS.size());
        for (int i = 0; i < CORNERS.size(); ++i) {
            Assert.assertEquals(polygon.getCornerPoints().get(i), (Object)CORNERS.get(i));
        }
        Assert.assertNull((Object)polygon.getLocationLines());
        Assert.assertEquals((Object)polygon.getLocationType(), (Object)LocationType.POLYGON);
        Assert.assertNull((Object)polygon.getLowerLeftPoint());
        Assert.assertTrue((polygon.getNegativeOffset() <= 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)polygon.getNumberOfColumns(), (int)-1);
        Assert.assertEquals((int)polygon.getNumberOfRows(), (int)-1);
        Assert.assertNull((Object)polygon.getOrientation());
        Assert.assertNull((Object)polygon.getPoiLine());
        Assert.assertNull((Object)polygon.getPointLocation());
        Assert.assertNull((Object)polygon.getReturnCode());
        Assert.assertTrue((polygon.getPositiveOffset() <= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)polygon.getSideOfRoad());
        Assert.assertNull((Object)polygon.getUpperRightPoint());
        Assert.assertTrue((boolean)polygon.isValid());
        Assert.assertFalse((boolean)polygon.hasNegativeOffset());
        Assert.assertFalse((boolean)polygon.hasPositiveOffset());
        Assert.assertEquals((long)polygon.getRadius(), (long)-1L);
    }

    @Test
    public final void testClosedLine() {
        Assert.assertNotNull((Object)closedLine.getID());
        Assert.assertNull((Object)closedLine.getAccessPoint());
        Assert.assertNull((Object)closedLine.getAffectedLines());
        Assert.assertNull((Object)closedLine.getCenterPoint());
        Assert.assertNull((Object)closedLine.getCornerPoints());
        Assert.assertNotNull((Object)closedLine.getLocationLines());
        Assert.assertEquals((int)closedLine.getLocationLines().size(), (int)LINES_LINE_LOCATION.size());
        for (int i = 0; i < LINES_LINE_LOCATION.size(); ++i) {
            Assert.assertEquals(closedLine.getLocationLines().get(i), (Object)LINES_LINE_LOCATION.get(i));
        }
        Assert.assertEquals((Object)closedLine.getLocationType(), (Object)LocationType.CLOSED_LINE);
        Assert.assertNull((Object)closedLine.getLowerLeftPoint());
        Assert.assertTrue((closedLine.getNegativeOffset() <= 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)closedLine.getNumberOfColumns(), (int)-1);
        Assert.assertEquals((int)closedLine.getNumberOfRows(), (int)-1);
        Assert.assertNull((Object)closedLine.getOrientation());
        Assert.assertNull((Object)closedLine.getPoiLine());
        Assert.assertNull((Object)closedLine.getPointLocation());
        Assert.assertNull((Object)closedLine.getReturnCode());
        Assert.assertTrue((closedLine.getPositiveOffset() <= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)closedLine.getSideOfRoad());
        Assert.assertNull((Object)closedLine.getUpperRightPoint());
        Assert.assertTrue((boolean)closedLine.isValid());
        Assert.assertFalse((boolean)closedLine.hasNegativeOffset());
        Assert.assertFalse((boolean)closedLine.hasPositiveOffset());
        Assert.assertEquals((long)closedLine.getRadius(), (long)-1L);
    }

    @Test
    public final void testComparison() {
        try {
            GeoCoordLocation geoLoc2 = new GeoCoordLocation(geoLoc);
            CommonObjectTestUtils.testCompare(geoLoc, geoLoc2, this.lineLocNoOff);
            LineLocation lineLoc2 = new LineLocation(this.lineLocOff);
            CommonObjectTestUtils.testCompare(this.lineLocOff, lineLoc2, this.lineLocNoOff);
            Assert.assertFalse((boolean)this.lineLocOff.equals((Object)geoLoc));
            PoiAccessLocation poiLoc2 = new PoiAccessLocation(poiLoc);
            Location poiLoc3 = LocationFactory.createPoiAccessLocation((String)"poi2", (Line)POI_LOC_LINE, (int)20, (double)LocationTypesTest.POI2.x, (double)LocationTypesTest.POI2.y);
            CommonObjectTestUtils.testCompare(poiLoc, poiLoc2, poiLoc3);
            Assert.assertFalse((boolean)poiLoc.equals((Object)geoLoc));
            PointAlongLocation palLoc2 = new PointAlongLocation(palLoc);
            CommonObjectTestUtils.testCompare(palLoc, palLoc2, palLocAtNode);
            Assert.assertFalse((boolean)palLoc.equals((Object)poiLoc));
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        InvalidLocation invalidLoc = new InvalidLocation("inv", (StatusCode)new TestStatusCode(), LocationType.CIRCLE);
        InvalidLocation invalidLocEqual = new InvalidLocation("inv", (StatusCode)new TestStatusCode(), LocationType.CIRCLE);
        InvalidLocation invalidLocUnEqual = new InvalidLocation("invUn", (StatusCode)new TestStatusCode(), LocationType.POLYGON);
        CommonObjectTestUtils.testCompare(invalidLoc, invalidLocEqual, invalidLocUnEqual);
        CommonObjectTestUtils.testToString(invalidLoc);
        try {
            RectangleLocation rectangleEqual = (RectangleLocation)LocationFactory.createRectangleLocation((String)"rectangle2", (GeoCoordinates)RECTANGLE_LL, (GeoCoordinates)RECTANGLE_UR);
            RectangleLocation rectangleUnEqual = (RectangleLocation)LocationFactory.createRectangleLocation((String)"rectangle2", (GeoCoordinates)new GeoCoordinatesImpl(0.0, 0.0), (GeoCoordinates)RECTANGLE_UR);
            CommonObjectTestUtils.testCompare(rectangle, rectangleEqual, rectangleUnEqual);
            CommonObjectTestUtils.testToString(rectangle);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        try {
            GridLocation gridBasisEqual = (GridLocation)LocationFactory.createGridLocationFromBasisCell((String)"gridBasis2", (GeoCoordinates)RECTANGLE_LL, (GeoCoordinates)RECTANGLE_UR, (int)4, (int)5);
            CommonObjectTestUtils.testCompare(gridBasis, gridBasisEqual, gridArea);
            CommonObjectTestUtils.testToString(gridBasis);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        PolygonLocation polygonEqual = (PolygonLocation)LocationFactory.createPolygonLocation((String)"polygon2", (List)polygon.getCornerPoints());
        try {
            PolygonLocation polygonUnEqual = (PolygonLocation)LocationFactory.createPolygonLocation((String)"polygonUnequal", Arrays.asList(new GeoCoordinatesImpl(0.0, 0.0), new GeoCoordinatesImpl(1.0, 1.0)));
            CommonObjectTestUtils.testCompare(polygon, polygonEqual, polygonUnEqual);
            CommonObjectTestUtils.testToString(polygon);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        try {
            CircleLocation circleEqual = (CircleLocation)LocationFactory.createCircleLocation((String)"circle2", (double)circleSmall.getCenterPoint().getLongitudeDeg(), (double)circleSmall.getCenterPoint().getLatitudeDeg(), (long)circleSmall.getRadius());
            CommonObjectTestUtils.testCompare(circleSmall, circleEqual, circleLarge);
            CommonObjectTestUtils.testToString(circleSmall);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        ClosedLineLocation closedLineEqual = (ClosedLineLocation)LocationFactory.createClosedLineLocation((String)"closedLine2", LINES_LINE_LOCATION);
        ClosedLineLocation closedLineUnEqual = (ClosedLineLocation)LocationFactory.createClosedLineLocation((String)"closedLineUn", Arrays.asList(MDB.getLine(1L), MDB.getLine(2L)));
        CommonObjectTestUtils.testCompare(closedLine, closedLineEqual, closedLineUnEqual);
        CommonObjectTestUtils.testToString(closedLine);
    }

    static {
        RECTANGLE_CORNERS = new ArrayList<GeoCoordinates>();
        CORNERS = new ArrayList<GeoCoordinates>();
        SCALED_RECTANGLE_CORNERS = new ArrayList<GeoCoordinates>();
        try {
            MDB = new MockedMapDatabase(DEFAULT_MAP_DB_CONFIG, false);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException("Unexpected exception during mock build-up from config file DefaultMapDatabase.xml", e);
        }
        LINES_LINE_LOCATION = Arrays.asList(MDB.getLine(4L), MDB.getLine(6L));
        POI_LOC_LINE = MDB.getLine(6L);
        POI = new Point2D.Double(6.12699, 49.60728);
        POI2 = new Point2D.Double(6.1256, 49.607);
        GeoCoordinatesImpl ll = null;
        GeoCoordinatesImpl ur = null;
        GeoCoordinatesImpl scaled = null;
        try {
            ll = new GeoCoordinatesImpl(5.0903, 52.08591);
            ur = new GeoCoordinatesImpl(5.12141, 52.10437);
            scaled = new GeoCoordinatesImpl(5.09808, 52.0896);
            CORNERS.add((GeoCoordinates)new GeoCoordinatesImpl(5.06853, 52.05942));
            CORNERS.add((GeoCoordinates)new GeoCoordinatesImpl(5.06019, 52.07334));
            CORNERS.add((GeoCoordinates)new GeoCoordinatesImpl(5.08782, 52.07235));
            RECTANGLE_CORNERS.add((GeoCoordinates)ll);
            RECTANGLE_CORNERS.add((GeoCoordinates)new GeoCoordinatesImpl(5.12141, 52.08591));
            RECTANGLE_CORNERS.add((GeoCoordinates)ur);
            RECTANGLE_CORNERS.add((GeoCoordinates)new GeoCoordinatesImpl(5.0903, 52.10437));
            SCALED_RECTANGLE_CORNERS.add((GeoCoordinates)ll);
            SCALED_RECTANGLE_CORNERS.add((GeoCoordinates)new GeoCoordinatesImpl(5.09808, 52.08591));
            SCALED_RECTANGLE_CORNERS.add((GeoCoordinates)scaled);
            SCALED_RECTANGLE_CORNERS.add((GeoCoordinates)new GeoCoordinatesImpl(5.0903, 52.0896));
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        RECTANGLE_LL = ll;
        RECTANGLE_UR = ur;
        SCALED_UR = scaled;
        Location l = null;
        try {
            l = LocationFactory.createGeoCoordinateLocation((String)"wpGeo", (double)LocationTypesTest.GEO_COORDINATE.x, (double)LocationTypesTest.GEO_COORDINATE.y);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        geoLoc = (GeoCoordLocation)l;
        try {
            l = LocationFactory.createPoiAccessLocationWithSideAndOrientation((String)"poi", (Line)POI_LOC_LINE, (int)20, (double)LocationTypesTest.POI.x, (double)LocationTypesTest.POI.y, (SideOfRoad)SideOfRoad.LEFT, (Orientation)Orientation.BOTH);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        poiLoc = (PoiAccessLocation)l;
        try {
            l = LocationFactory.createPoiAccessAtNodeLocationWithSideAndOrientation((String)"poiAtNode", (Line)POI_LOC_LINE, (double)LocationTypesTest.POI.x, (double)LocationTypesTest.POI.y, (SideOfRoad)SideOfRoad.RIGHT, (Orientation)Orientation.WITH_LINE_DIRECTION);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        poiLocAtNode = (PoiAccessLocation)l;
        try {
            l = LocationFactory.createPointAlongLineLocationWithSideAndOrientation((String)"pal", (Line)POI_LOC_LINE, (int)20, (SideOfRoad)SideOfRoad.LEFT, (Orientation)Orientation.BOTH);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        palLoc = (PointAlongLocation)l;
        try {
            l = LocationFactory.createNodeLocation((String)"palAtNode", (Line)POI_LOC_LINE);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        palLocAtNode = (PointAlongLocation)l;
        try {
            l = LocationFactory.createCircleLocation((String)"circleSmall", (double)6.12699, (double)49.60728, (long)100L);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        circleSmall = (CircleLocation)l;
        try {
            l = LocationFactory.createCircleLocation((String)"circleMedium", (double)6.12699, (double)49.60728, (long)60000L);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        circleMedium = (CircleLocation)l;
        try {
            l = LocationFactory.createCircleLocation((String)"circleSmall", (double)6.12699, (double)49.60728, (long)16000000L);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        circleLarge = (CircleLocation)l;
        try {
            l = LocationFactory.createCircleLocation((String)"circleSmall", (double)6.12699, (double)49.60728, (long)4000000000L);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        circleExtraLarge = (CircleLocation)l;
        try {
            l = LocationFactory.createRectangleLocation((String)"rectangle", (GeoCoordinates)RECTANGLE_LL, (GeoCoordinates)RECTANGLE_UR);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        rectangle = (RectangleLocation)l;
        try {
            l = LocationFactory.createGridLocationFromBasisCell((String)"gridBasis", (GeoCoordinates)RECTANGLE_LL, (GeoCoordinates)RECTANGLE_UR, (int)4, (int)5);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        gridBasis = (GridLocation)l;
        try {
            l = LocationFactory.createGridLocationFromGridArea((String)"gridArea", (GeoCoordinates)RECTANGLE_LL, (GeoCoordinates)RECTANGLE_UR, (int)4, (int)5);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        gridArea = (GridLocation)l;
        polygon = (PolygonLocation)LocationFactory.createPolygonLocation((String)"polygon", CORNERS);
        closedLine = (ClosedLineLocation)LocationFactory.createClosedLineLocation((String)"closedLine", LINES_LINE_LOCATION);
    }

    private static final class TestStatusCode
    implements StatusCode {
        private TestStatusCode() {
        }

        public String name() {
            return "DummyStatus";
        }

        public int getID() {
            return 0;
        }
    }
}

