/*
 * Decompiled with CFR 0.152.
 */
package openlr.location.utils;

import java.util.NoSuchElementException;
import openlr.location.Location;
import openlr.location.utils.LocationData;
import openlr.location.utils.LocationDataIterator;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LocationDataIteratorTest {
    private static Mockery mockery = new Mockery();
    private final LocationData someLocationData = this.mockSomeLocationData(5);

    @Test
    public final void testIteration() {
        LocationDataIterator iterator = new LocationDataIterator(this.someLocationData);
        Assert.assertEquals((int)this.someLocationData.numberOfLocations(), (int)iterator.size());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertFalse((boolean)iterator.hasPrevious());
        Assert.assertEquals((int)-1, (int)iterator.currentIndex());
        Assert.assertEquals(null, (Object)iterator.current());
        try {
            iterator.previous();
        }
        catch (NoSuchElementException e) {
            Assert.assertTrue((e != null ? 1 : 0) != 0);
        }
        iterator.next();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertFalse((boolean)iterator.hasPrevious());
        Assert.assertEquals((int)0, (int)iterator.currentIndex());
        Assert.assertEquals((String)"0", (String)iterator.current().getID());
        Assert.assertEquals((int)1, (int)iterator.nextIndex());
        Location loc = iterator.next();
        Assert.assertEquals((String)"1", (String)loc.getID());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasPrevious());
        Assert.assertEquals((int)1, (int)iterator.currentIndex());
        Assert.assertEquals((String)"1", (String)iterator.current().getID());
        Assert.assertEquals((String)"0", (String)iterator.previous().getID());
        try {
            iterator.setCurrent(this.someLocationData.numberOfLocations());
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertTrue((e != null ? 1 : 0) != 0);
        }
        try {
            iterator.setCurrent(-1);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertTrue((e != null ? 1 : 0) != 0);
        }
        int lastIndex = this.someLocationData.numberOfLocations() - 1;
        Location locLast = iterator.setCurrent(lastIndex);
        Assert.assertEquals((String)String.valueOf(lastIndex), (String)locLast.getID());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasPrevious());
        Assert.assertEquals((int)lastIndex, (int)iterator.currentIndex());
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            Assert.assertTrue((e != null ? 1 : 0) != 0);
        }
        iterator.setCurrent(0);
        Assert.assertEquals((String)"0", (String)iterator.current().getID());
    }

    @Test
    public final void testGeneralIteratorInterface() {
        int numberLocations = this.someLocationData.numberOfLocations();
        LocationDataIterator iterator = new LocationDataIterator(this.someLocationData);
        Assert.assertEquals((int)-1, (int)iterator.previousIndex());
        Assert.assertEquals((int)0, (int)iterator.nextIndex());
        int count = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((String)String.valueOf(count), (String)((Location)iterator.next()).getID());
            ++count;
        }
        Assert.assertEquals((int)numberLocations, (int)iterator.nextIndex());
        Assert.assertTrue((count == numberLocations ? 1 : 0) != 0);
    }

    private LocationData mockSomeLocationData(int count) {
        LocationData data = new LocationData();
        for (int i = 0; i < count; ++i) {
            data.addLocation(this.mockALocation(String.valueOf(i)));
        }
        data.addError("An error in loading locations");
        return data;
    }

    private Location mockALocation(final String id) {
        final Location loc = (Location)mockery.mock(Location.class, id);
        mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Location)this.allowing(loc)).getID();
                this.will(1.returnValue((Object)id));
            }
        });
        return loc;
    }
}

