/*
 * Decompiled with CFR 0.152.
 */
package openlr.testutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class CoberturaCoverageAnalyzer {
    private static final String[] ANALYZED_PACKAGES = new String[]{"data", "map", "encoder", "decoder", "xml", "binary", "datex2"};
    private static final String PATTERN_BASE_LINE_RATE = "(line-rate=\"0\\.[0-9]+\")";
    private static final String PATH_TO_COVERAGE_REPORT = "target/site/cobertura/coverage.xml";

    private CoberturaCoverageAnalyzer() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        int result = 0;
        for (String pack : ANALYZED_PACKAGES) {
            if (CoberturaCoverageAnalyzer.checkCoverageForPackage(pack)) continue;
            result = -1;
        }
        System.out.println("Done, result: " + result);
    }

    private static boolean checkCoverageForPackage(String pack) {
        boolean coverageOk = true;
        File coverageReport = new File("../" + pack + "/" + PATH_TO_COVERAGE_REPORT);
        System.out.println("===============\nChecking package \"" + pack + "\" (file: " + coverageReport.getAbsolutePath() + ")\n===============");
        if (coverageReport.exists()) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(coverageReport));
                int lineCount = 1;
                while ((line = reader.readLine()) != null) {
                    for (AnalyzedMethods method : AnalyzedMethods.getMethods()) {
                        Matcher matcher = method.pattern.matcher(line);
                        if (!matcher.find()) continue;
                        coverageOk = false;
                        System.out.println("line " + lineCount + " " + method.methodName + ": " + matcher.group(1));
                    }
                    ++lineCount;
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("ERROR: " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("ERROR: " + e.getMessage());
            }
            if (coverageOk) {
                System.out.println("Coverage OK!");
            }
        } else {
            System.out.println("No cobertura coverage report found! (" + coverageReport + ")");
            System.out.println("You should run mvn cobertura:cobertura inside this package!");
        }
        return coverageOk;
    }

    private static enum AnalyzedMethods {
        EQUALS(Pattern.compile("\"equals\".*(line-rate=\"0\\.[0-9]+\")"), "equals"),
        HASH_CODE(Pattern.compile("\"hashCode\".*(line-rate=\"0\\.[0-9]+\")"), "hashCode"),
        TO_STRING(Pattern.compile("\"toString\".*(line-rate=\"0\\.[0-9]+\")"), "toString");

        private static final List<AnalyzedMethods> VALUES;
        private Pattern pattern;
        private String methodName;

        private AnalyzedMethods(Pattern pat, String name) {
            this.pattern = pat;
            this.methodName = name;
        }

        public static List<AnalyzedMethods> getMethods() {
            return VALUES;
        }

        static {
            VALUES = Collections.unmodifiableList(Arrays.asList(AnalyzedMethods.values()));
        }
    }
}

