/*
 * Decompiled with CFR 0.152.
 */
package openlr.utils.locref.boundary;

import java.util.ArrayList;
import java.util.Arrays;
import openlr.LocationReferencePoint;
import openlr.location.data.Orientation;
import openlr.location.data.SideOfRoad;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.RectangleCorners;
import openlr.rawLocRef.RawCircleLocRef;
import openlr.rawLocRef.RawGeoCoordLocRef;
import openlr.rawLocRef.RawGridLocRef;
import openlr.rawLocRef.RawLineLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.rawLocRef.RawPointAlongLocRef;
import openlr.rawLocRef.RawPolygonLocRef;
import openlr.rawLocRef.RawRectangleLocRef;
import openlr.utils.locref.boundary.LocRefBoundary;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LocRefBoundaryTest {
    private static final double VALID_COORDINATE_DELTA = 5.0E-6;
    private final Mockery mockery = new Mockery();

    @Test
    public final void testLineLocationReference() {
        LocationReferencePoint lrp1 = this.mockLRP(5.110692, 52.10059, 147);
        LocationReferencePoint lrp2 = this.mockLRP(5.108922, 52.1003, 0);
        RawLineLocRef lineLocRef = new RawLineLocRef("id", Arrays.asList(lrp1, lrp2), null);
        this.calculateBox((RawLocationReference)lineLocRef, 5.10861, 52.09999, 5.111, 52.1009);
    }

    @Test
    public final void testPointAlongLineLocationReference() {
        LocationReferencePoint lrp1 = this.mockLRP(5.10009, 52.10825, 147);
        LocationReferencePoint lrp2 = this.mockLRP(5.10115, 52.10926, 0);
        RawPointAlongLocRef lineLocRef = new RawPointAlongLocRef("id", lrp1, lrp2, null, SideOfRoad.ON_ROAD_OR_UNKNOWN, Orientation.NO_ORIENTATION_OR_UNKNOWN);
        this.calculateBox((RawLocationReference)lineLocRef, 5.099618, 52.107777, 5.10162, 52.10973);
    }

    @Test
    public final void testRectangleLocationReference() throws InvalidMapDataException {
        GeoCoordinatesImpl ll = new GeoCoordinatesImpl(5.10007, 52.10321);
        GeoCoordinatesImpl ur = new GeoCoordinatesImpl(5.10398, 52.10704);
        RawRectangleLocRef lineLocRef = new RawRectangleLocRef("id", (GeoCoordinates)ll, (GeoCoordinates)ur);
        this.calculateBox((RawLocationReference)lineLocRef, ll.getLatitudeDeg(), ll.getLongitudeDeg(), ur.getLatitudeDeg(), ur.getLongitudeDeg());
    }

    @Test
    public final void testGridLocationReference() throws InvalidMapDataException {
        GeoCoordinatesImpl ll = new GeoCoordinatesImpl(5.10007, 52.10321);
        GeoCoordinatesImpl ur = new GeoCoordinatesImpl(5.10398, 52.10704);
        RawGridLocRef lineLocRef = new RawGridLocRef("id", (GeoCoordinates)ll, (GeoCoordinates)ur, 3, 2);
        this.calculateBox((RawLocationReference)lineLocRef, ll.getLatitudeDeg(), ll.getLongitudeDeg(), 52.11087, 5.1118);
    }

    @Test
    public final void testCircleLocationReference() throws InvalidMapDataException {
        GeoCoordinatesImpl center = new GeoCoordinatesImpl(5.10185, 52.10598);
        RawCircleLocRef lineLocRef = new RawCircleLocRef("id", (GeoCoordinates)center, 300L);
        this.calculateBox((RawLocationReference)lineLocRef, 52.10329, 5.09746, 52.10867, 5.10624);
    }

    @Test
    public final void testGeoCoordinateLocationReference() throws InvalidMapDataException {
        GeoCoordinatesImpl coordinate = new GeoCoordinatesImpl(5.0979, 52.10887);
        RawGeoCoordLocRef lineLocRef = new RawGeoCoordLocRef("id", (GeoCoordinates)coordinate);
        this.calculateBox((RawLocationReference)lineLocRef, 52.10887, 5.0979, 52.10888, 5.09791);
    }

    @Test
    public final void testPolygonLocationReference() throws InvalidMapDataException {
        ArrayList<GeoCoordinatesImpl> corners = new ArrayList<GeoCoordinatesImpl>();
        corners.add(new GeoCoordinatesImpl(5.09936, 52.10306));
        corners.add(new GeoCoordinatesImpl(5.10516, 52.10432));
        corners.add(new GeoCoordinatesImpl(5.1046, 52.107354));
        corners.add(new GeoCoordinatesImpl(5.1019, 52.10933));
        corners.add(new GeoCoordinatesImpl(5.0988, 52.107374));
        RawPolygonLocRef lineLocRef = new RawPolygonLocRef("id", corners);
        this.calculateBox((RawLocationReference)lineLocRef, 52.10306, 5.0988, 52.10933, 5.10516);
    }

    private void calculateBox(RawLocationReference locRef, double expectedLatLL, double expectedLonLL, double expectedLatUR, double expectedLongUR) {
        try {
            RectangleCorners bbox = LocRefBoundary.calculateLocRefBoundary((RawLocationReference)locRef);
            GeoCoordinates lowerLeft = bbox.getLowerLeft();
            GeoCoordinates upperRight = bbox.getUpperRight();
            Assert.assertEquals((double)expectedLatLL, (double)lowerLeft.getLatitudeDeg(), (double)5.0E-6);
            Assert.assertEquals((double)expectedLonLL, (double)lowerLeft.getLongitudeDeg(), (double)5.0E-6);
            Assert.assertEquals((double)expectedLatUR, (double)upperRight.getLatitudeDeg(), (double)5.0E-6);
            Assert.assertEquals((double)expectedLongUR, (double)upperRight.getLongitudeDeg(), (double)5.0E-6);
        }
        catch (InvalidMapDataException e) {
            Assert.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    private LocationReferencePoint mockLRP(final double latitude, final double longitude, final int dnp) {
        final LocationReferencePoint lrp = (LocationReferencePoint)this.mockery.mock(LocationReferencePoint.class, "lrp" + latitude + "-" + longitude + "-" + dnp);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((LocationReferencePoint)this.allowing(lrp)).getLatitudeDeg();
                this.will(1.returnValue((Object)latitude));
            }
        });
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((LocationReferencePoint)this.allowing(lrp)).getLongitudeDeg();
                this.will(2.returnValue((Object)longitude));
            }
        });
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((LocationReferencePoint)this.allowing(lrp)).getDistanceToNext();
                this.will(3.returnValue((Object)dnp));
            }
        });
        return lrp;
    }
}

