/*
 * Decompiled with CFR 0.152.
 */
package org.openlr.geo;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.GeometricShapeFactory;

public class Geo {
    private static final int EARTH_RADIUS_METERS = 6371000;
    private static final int EARTH_CIRCUMFERENCE_METERS = 40075000;
    private static final int DEGREES_IN_CIRCLE = 360;
    private final GeometryFactory geometryFactory;

    public Geo(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public Geo() {
        this(new GeometryFactory());
    }

    public double calculateDistance(Coordinate coordinateA, Coordinate coordinateB) {
        double aYRadians = Math.toRadians(coordinateA.y);
        double bYRadians = Math.toRadians(coordinateB.y);
        double dX = Math.toRadians(coordinateB.x - coordinateA.x);
        double dY = Math.toRadians(coordinateB.y - coordinateA.y);
        double a = Math.cos(aYRadians) * Math.cos(bYRadians) * Math.sin(dX / 2.0) * Math.sin(dX / 2.0) + Math.sin(dY / 2.0) * Math.sin(dY / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return c * 6371000.0;
    }

    public double calculateDistance(Point pointA, Point pointB) {
        return this.calculateDistance(pointA.getCoordinate(), pointB.getCoordinate());
    }

    public double calculateBearing(Coordinate from, Coordinate to) {
        double fromXRadians = Math.toRadians(from.x);
        double fromYRadians = Math.toRadians(from.y);
        double toXRadians = Math.toRadians(to.x);
        double toYRadians = Math.toRadians(to.y);
        double y = Math.sin(toXRadians - fromXRadians) * Math.cos(toYRadians);
        double x = Math.cos(fromYRadians) * Math.sin(toYRadians) - Math.sin(fromYRadians) * Math.cos(toYRadians) * Math.cos(toXRadians - fromXRadians);
        double theta = Math.atan2(y, x);
        return (Math.toDegrees(theta) + 360.0) % 360.0;
    }

    public double calculateBearing(Point from, Point to) {
        return this.calculateBearing(from.getCoordinate(), to.getCoordinate());
    }

    public double calculateBearingDifference(double bearingA, double bearingB) {
        double difference = Math.abs(bearingB - bearingA) % 360.0;
        return difference > 180.0 ? 360.0 - difference : difference;
    }

    public double projectOnLineString(Coordinate coordinate, LineString lineString) {
        double totalLength = 0.0;
        Double minDistance = null;
        Double distanceAlong = null;
        for (int i = 1; i < lineString.getNumPoints(); ++i) {
            Coordinate from = lineString.getCoordinateN(i - 1);
            Coordinate to = lineString.getCoordinateN(i);
            double segmentLength = this.calculateDistance(from, to);
            double fraction = this.project(coordinate, from, to);
            Coordinate projectionPoint = this.coordinateAlong(from, to, fraction);
            double projectionDistance = this.calculateDistance(coordinate, projectionPoint);
            if (minDistance == null || projectionDistance < minDistance) {
                minDistance = projectionDistance;
                distanceAlong = totalLength + segmentLength * fraction;
            }
            totalLength += segmentLength;
        }
        if (distanceAlong == null) {
            throw new IllegalStateException();
        }
        return distanceAlong / totalLength;
    }

    public Coordinate calculateCoordinateAlongLineString(LineString lineString, double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new IllegalArgumentException("Fraction should be between 0 and 1");
        }
        if (fraction == 0.0) {
            return lineString.getCoordinateN(0);
        }
        if (fraction == 1.0) {
            return lineString.getCoordinateN(lineString.getNumPoints() - 1);
        }
        if (lineString.getNumPoints() == 2) {
            Coordinate from = lineString.getCoordinateN(0);
            Coordinate to = lineString.getCoordinateN(1);
            return this.coordinateAlong(from, to, fraction);
        }
        ArrayList<Double> segmentLengths = new ArrayList<Double>();
        double totalLength = 0.0;
        for (int i = 1; i < lineString.getNumPoints(); ++i) {
            Coordinate from = lineString.getCoordinateN(i - 1);
            Coordinate to = lineString.getCoordinateN(i);
            double segmentLength = this.calculateDistance(from, to);
            segmentLengths.add(segmentLength);
            totalLength += segmentLength;
        }
        double distanceAlong = totalLength * fraction;
        int i = 0;
        while (distanceAlong > (Double)segmentLengths.get(i)) {
            distanceAlong -= ((Double)segmentLengths.get(i)).doubleValue();
            ++i;
        }
        double fractionAlongSegment = distanceAlong / (Double)segmentLengths.get(i);
        Coordinate from = lineString.getCoordinateN(i);
        Coordinate to = lineString.getCoordinateN(i + 1);
        return this.coordinateAlong(from, to, fractionAlongSegment);
    }

    public Point calculatePointAlongLineString(LineString lineString, double fraction) {
        Coordinate coordinate = this.calculateCoordinateAlongLineString(lineString, fraction);
        return this.geometryFactory.createPoint(coordinate);
    }

    public LineString joinLineStrings(List<LineString> lineStrings) {
        if (lineStrings.isEmpty()) {
            throw new IllegalArgumentException("At least one line string expected");
        }
        LineString firstLineString = lineStrings.get(0);
        Coordinate currentCoordinate = firstLineString.getCoordinateN(0);
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(currentCoordinate);
        for (LineString lineString : lineStrings) {
            Coordinate firstCoordinate = lineString.getCoordinateN(0);
            if (!firstCoordinate.equals((Object)currentCoordinate)) {
                throw new IllegalArgumentException("Line strings are not connected");
            }
            for (int i = 1; i < lineString.getNumPoints(); ++i) {
                currentCoordinate = lineString.getCoordinateN(i);
                coordinates.add(currentCoordinate);
            }
        }
        return this.geometryFactory.createLineString((Coordinate[])coordinates.toArray(Coordinate[]::new));
    }

    public LineString sliceLineString(LineString lineString, double startFraction, double stopFraction) {
        ArrayList<Double> segmentLengths = new ArrayList<Double>();
        double totalLength = 0.0;
        for (int i = 1; i < lineString.getNumPoints(); ++i) {
            Coordinate from = lineString.getCoordinateN(i - 1);
            Coordinate to = lineString.getCoordinateN(i);
            double segmentLength = this.calculateDistance(from, to);
            segmentLengths.add(segmentLength);
            totalLength += segmentLength;
        }
        double startLength = totalLength * startFraction;
        double stopLength = totalLength * stopFraction;
        double lengthSoFar = 0.0;
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (int i = 1; i < lineString.getNumPoints(); ++i) {
            double fractionAlong;
            double overshoot;
            double segmentLength = (Double)segmentLengths.get(i - 1);
            double nextLengthSoFar = lengthSoFar + segmentLength;
            Coordinate from = lineString.getCoordinateN(i - 1);
            Coordinate to = lineString.getCoordinateN(i);
            if (nextLengthSoFar >= startLength && coordinates.isEmpty()) {
                overshoot = nextLengthSoFar - startLength;
                fractionAlong = (segmentLength - overshoot) / segmentLength;
                Coordinate start = this.coordinateAlong(from, to, fractionAlong);
                coordinates.add(start);
            }
            if (lengthSoFar > startLength && lengthSoFar < stopLength) {
                coordinates.add(from);
            }
            if (nextLengthSoFar >= stopLength) {
                overshoot = nextLengthSoFar - stopLength;
                fractionAlong = (segmentLength - overshoot) / segmentLength;
                Coordinate stop = this.coordinateAlong(from, to, fractionAlong);
                coordinates.add(stop);
                break;
            }
            lengthSoFar = nextLengthSoFar;
        }
        return this.geometryFactory.createLineString((Coordinate[])coordinates.toArray(Coordinate[]::new));
    }

    public Polygon approximateCircle(Coordinate center, double radius) {
        return this.approximateCircle(center, radius, 32);
    }

    public Polygon approximateCircle(Coordinate center, double radius, int numberOfPoints) {
        double width = radius * 2.0 / (4.0075E7 * Math.cos(Math.toRadians(center.getY())) / 360.0);
        double height = radius * 2.0 / 111319.0;
        GeometricShapeFactory geometricShapeFactory = new GeometricShapeFactory();
        geometricShapeFactory.setCentre(center);
        geometricShapeFactory.setWidth(width);
        geometricShapeFactory.setHeight(height);
        geometricShapeFactory.setNumPoints(numberOfPoints);
        return geometricShapeFactory.createEllipse();
    }

    private double project(Coordinate coordinate, Coordinate coordinateA, Coordinate coordinateB) {
        if (coordinate.equals((Object)coordinateA)) {
            return 0.0;
        }
        if (coordinate.equals((Object)coordinateB)) {
            return 1.0;
        }
        double d1 = this.calculateDistance(coordinateA, coordinateB);
        double d2 = this.calculateDistance(coordinateA, coordinate);
        double d3 = this.calculateDistance(coordinateB, coordinate);
        double d1Square = d1 * d1;
        double d2Square = d2 * d2;
        double d3Square = d3 * d3;
        double cos = (d2Square + d1Square - d3Square) / (2.0 * d2 * d1);
        double d = cos * d2;
        double fraction = d / d1;
        return Math.min(Math.max(fraction, 0.0), 1.0);
    }

    private Coordinate coordinateAlong(Coordinate from, Coordinate to, double fraction) {
        double x = from.x + (to.x - from.x) * fraction;
        double y = from.y + (to.y - from.y) * fraction;
        return new Coordinate(x, y);
    }
}

