/*
 * Decompiled with CFR 0.152.
 */
package container;

import better.files.File;
import better.files.File$;
import container.ImageBuilder$CommandExecutionError$;
import container.Status;
import container.Status$DIRECTORY_FILE_COLLISION$;
import container.Status$IO_ERROR$;
import container.Status$OK$;
import container.Status$SECURITY_ERROR$;
import container.Status$UNKNOWN_ERROR$;
import java.io.IOException;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.sys.process.ProcessLogger$;
import scala.sys.process.package$;

public final class Extractor$
implements Serializable {
    public static final Extractor$ MODULE$ = new Extractor$();

    private Extractor$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Extractor$.class);
    }

    public Tuple2<String, String> getPathAndFileName(String filepath) {
        String[] files = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(filepath), '/');
        String filename = files[files.length - 1];
        String path = filepath.substring(0, filepath.length() - filename.length());
        return Tuple2$.MODULE$.apply((Object)path, (Object)filename);
    }

    public boolean isAnArchive(String filename) {
        return filename.endsWith(".tar") || filename.endsWith(".gz") || filename.endsWith(".tgz") || filename.endsWith(".zip") || filename.endsWith(".bz2") || filename.endsWith(".xz") || filename.endsWith(".7z") || filename.endsWith(".rar");
    }

    public String getDirectoryPath(String path, String fileName) {
        String directoryPath = path.isEmpty() ? "./" : path;
        String directoryName = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(fileName), '.')[0];
        return directoryPath + directoryName;
    }

    public String completeDirectoryPath(String path) {
        if (path.endsWith("/")) {
            return path;
        }
        return path + "/";
    }

    public Status.Status createDirectory(String directoryPath) {
        File directory = File$.MODULE$.apply(directoryPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (directory.exists(directory.exists$default$1()) && !directory.isDirectory(directory.isDirectory$default$1())) {
            return Status$DIRECTORY_FILE_COLLISION$.MODULE$.withArgument(directoryPath);
        }
        try {
            directory.createDirectory(directory.createDirectory$default$1());
            return Status$OK$.MODULE$;
        }
        catch (SecurityException se) {
            return Status$SECURITY_ERROR$.MODULE$.withArgument(se);
        }
        catch (IOException ioe) {
            return Status$IO_ERROR$.MODULE$.withArgument(ioe);
        }
        catch (Exception e) {
            return Status$UNKNOWN_ERROR$.MODULE$.withArgument(e);
        }
    }

    public Tuple3<Object, String, String> executeCommand(String cmd) {
        StringBuilder stdout = new StringBuilder();
        StringBuilder stderr = new StringBuilder();
        int status = package$.MODULE$.stringToProcess(cmd).$bang(ProcessLogger$.MODULE$.apply((Function1)(JProcedure1 & Serializable)_$1 -> stdout.append(_$1), (Function1)(JProcedure1 & Serializable)_$2 -> stderr.append(_$2)));
        if (status != 0) {
            throw ImageBuilder$CommandExecutionError$.MODULE$.apply(status, stdout.toString(), stderr.toString());
        }
        return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)status), (Object)stdout.toString(), (Object)stderr.toString());
    }

    public String extractLines(File file) {
        String string;
        String test = file.contentAsString(file.contentAsString$default$1());
        try (BufferedSource source = Source$.MODULE$.fromFile(file.pathAsString(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        String lines = string;
        return test;
    }
}

