/*
 * Decompiled with CFR 0.152.
 */
package container;

import better.files.File;
import better.files.File$;
import container.DockerMetadata;
import container.DockerMetadata$;
import container.Hash$;
import container.Hash$HashSource$;
import container.ImageDownloader;
import container.ImageDownloader$Config$;
import container.ImageDownloader$ContainerConf$;
import container.ImageDownloader$Executor$;
import container.ImageDownloader$HttpProxy$;
import container.ImageDownloader$ImageNotFound$;
import container.Registry$;
import container.Registry$Layer$;
import container.RegistryImage;
import container.package;
import container.package$SavedImage$;
import container.tool.Retry$;
import container.tool.lock$;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.HCursor;
import io.circe.Json;
import io.circe.Json$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.UUID;
import org.apache.http.HttpHost;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import squants.time.Time;

public final class ImageDownloader$
implements Serializable {
    public static final ImageDownloader$HttpProxy$ HttpProxy;
    public static final ImageDownloader$ContainerConf$ ContainerConf;
    public static final ImageDownloader$Config$ Config;
    public static final ImageDownloader$ImageNotFound$ ImageNotFound;
    public static final ImageDownloader$Executor$ Executor;
    public static final ImageDownloader$ MODULE$;

    private ImageDownloader$() {
    }

    static {
        MODULE$ = new ImageDownloader$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ImageDownloader$.class);
    }

    public String getManifestAsString(List<String> layersHash, String name, String tag, String configName) {
        String config = "[{\"Config\":\"" + configName + "\",";
        String repotag = "\"RepoTags\":[\"" + name + ":" + tag + "\"],";
        String layers = "\"Layers\":[";
        ObjectRef manifest = ObjectRef.create((Object)(config + repotag + layers));
        String last = (String)layersHash.reverse().last();
        ((List)layersHash.reverse().init()).foreach((Function1)(JProcedure1 & Serializable)hash -> {
            Object object;
            manifest$1.elem = object = (String)manifest$1.elem + "\"" + hash + "/layer.tar\",";
            object = null;
        });
        return (String)manifest.elem + "\"" + last + "/layer.tar\"]}]";
    }

    public String getConfigAsString(DockerMetadata.ImageManifestV2Schema1 manifest, Map<String, Option<String>> layersHash) {
        return DockerMetadata$.MODULE$.imageJSONEncoder().apply((Object)DockerMetadata$.MODULE$.v1HistoryToImageJson(manifest, layersHash)).toString();
    }

    public void writeManifestFile(String path, String manifest) {
        better.files.File file = File$.MODULE$.apply(path + "/manifest.json", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        file.appendLine(manifest, file.appendLine$default$2(manifest));
    }

    public File imageDirectory(File localRepository, RegistryImage image) {
        return better.files.package$.MODULE$.FileExtensions(localRepository).toScala().$div(image.name()).$div(image.tag()).toJava();
    }

    public package.SavedImage downloadContainerImage(RegistryImage dockerImage, File localRepository, Time timeout, Option<Object> retry, ImageDownloader.Executor executor, Option<ImageDownloader.HttpProxy> proxy) {
        int retryCount = BoxesRunTime.unboxToInt((Object)retry.getOrElse(this::$anonfun$1));
        Try<DockerMetadata.ImageManifestV2Schema1> decodedManifest = Registry$.MODULE$.decodeManifest((String)Retry$.MODULE$.retry(retryCount, () -> this.$anonfun$2(dockerImage, timeout, proxy)));
        Try<DockerMetadata.ImageManifestV2Schema1> try_ = decodedManifest;
        if (try_ instanceof Success) {
            DockerMetadata.ImageManifestV2Schema1 manifestValue = (DockerMetadata.ImageManifestV2Schema1)((Success)try_).value();
            better.files.File tmpDirectory = better.files.package$.MODULE$.FileExtensions(localRepository).toScala().$div(".tmp");
            better.files.File imageDirectoryValue = better.files.package$.MODULE$.FileExtensions(this.imageDirectory(localRepository, dockerImage)).toScala();
            better.files.File idsDirectory = imageDirectoryValue.$div("id");
            boolean bl = tmpDirectory.createDirectoryIfNotExists$default$1();
            tmpDirectory.createDirectoryIfNotExists(bl, tmpDirectory.createDirectoryIfNotExists$default$2(bl), tmpDirectory.createDirectoryIfNotExists$default$3(bl));
            boolean bl2 = imageDirectoryValue.createDirectoryIfNotExists$default$1();
            imageDirectoryValue.createDirectoryIfNotExists(bl2, imageDirectoryValue.createDirectoryIfNotExists$default$2(bl2), imageDirectoryValue.createDirectoryIfNotExists$default$3(bl2));
            boolean bl3 = idsDirectory.createDirectoryIfNotExists$default$1();
            idsDirectory.createDirectoryIfNotExists(bl3, idsDirectory.createDirectoryIfNotExists$default$2(bl3), idsDirectory.createDirectoryIfNotExists$default$3(bl3));
            List conf = (List)manifestValue.history().get();
            List raw = conf.map((Function1 & Serializable)_$1 -> _$1.v1Compatibility());
            List layersIDS = raw.map((Function1 & Serializable)x -> {
                boolean bl;
                Json parsed = (Json)io.circe.parser.package$.MODULE$.parse(x).getOrElse(this::$anonfun$5);
                HCursor cursor = parsed.hcursor();
                Either either = cursor.get("throwaway", Decoder$.MODULE$.decodeBoolean());
                if (either instanceof Right) {
                    boolean value;
                    bl = value = BoxesRunTime.unboxToBoolean((Object)((Right)either).value());
                } else if (either instanceof Left) {
                    DecodingFailure error = (DecodingFailure)((Left)either).value();
                    bl = false;
                } else {
                    throw new MatchError((Object)either);
                }
                boolean ignore = bl;
                Either either2 = cursor.get("id", Decoder$.MODULE$.decodeString());
                if (either2 instanceof Right) {
                    String id = (String)((Right)either2).value();
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)id);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)ignore));
                }
                if (either2 instanceof Left) {
                    DecodingFailure error = (DecodingFailure)((Left)either2).value();
                    throw error;
                }
                throw new MatchError((Object)either2);
            });
            List layersHash = ((List)manifestValue.fsLayers().get()).map((Function1 & Serializable)_$2 -> _$2.blobSum());
            Iterator infiniteConfig = conf.map((Function1 & Serializable)c -> Some$.MODULE$.apply((Object)c.v1Compatibility())).toIterator().$plus$plus(this::$anonfun$8);
            Iterator layersMap = layersHash.iterator().zip((IterableOnce)layersIDS.iterator()).zip((IterableOnce)infiniteConfig).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    String hash = (String)tuple2._1();
                    if (tuple23 != null) {
                        String id = (String)tuple23._1();
                        boolean ignore = BoxesRunTime.unboxToBoolean((Object)tuple23._2());
                        Option v1compat = (Option)tuple22._2();
                        return true;
                    }
                }
                return false;
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    String hash = (String)tuple2._1();
                    if (tuple23 != null) {
                        String id = (String)tuple23._1();
                        boolean ignore = BoxesRunTime.unboxToBoolean((Object)tuple23._2());
                        Option v1compat = (Option)tuple22._2();
                        return executor.apply(() -> this.$anonfun$10$$anonfun$1(dockerImage, timeout, proxy, retryCount, tmpDirectory, imageDirectoryValue, idsDirectory, hash, id, ignore, v1compat));
                    }
                }
                throw new MatchError((Object)tuple22);
            });
            Map layersHashMap = ((IterableOnceOps)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((IterableOnce)layersMap, BuildFrom$.MODULE$.buildFromIterator(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Duration$.MODULE$.Inf())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            DockerMetadata.ImageJSON imageJSON = DockerMetadata$.MODULE$.v1HistoryToImageJson(manifestValue, (Map<String, Option<String>>)layersHashMap);
            String configString = DockerMetadata$.MODULE$.imageJSONEncoder().apply((Object)imageJSON).toString();
            String configName = Hash$.MODULE$.sha256(Hash$HashSource$.MODULE$.fromString(configString), Hash$.MODULE$.sha256$default$2()) + ".json";
            better.files.File file = imageDirectoryValue.$div(configName);
            file.write(configString, file.write$default$2(configString), file.write$default$3(configString));
            String manifestString = this.getManifestAsString((List<String>)layersHash.flatMap((Function1 & Serializable)l -> (IterableOnce)layersHashMap.apply(l)), dockerImage.name(), dockerImage.tag(), configName);
            better.files.File file2 = imageDirectoryValue.$div("manifest.json");
            file2.write(manifestString, file2.write$default$2(manifestString), file2.write$default$3(manifestString));
            return package$SavedImage$.MODULE$.apply(imageDirectoryValue.toJava());
        }
        throw ImageDownloader$ImageNotFound$.MODULE$.apply(dockerImage);
    }

    public Option<Object> downloadContainerImage$default$4() {
        return None$.MODULE$;
    }

    public ImageDownloader.Executor downloadContainerImage$default$5() {
        return ImageDownloader$Executor$.MODULE$.sequential();
    }

    public Option<ImageDownloader.HttpProxy> downloadContainerImage$default$6() {
        return None$.MODULE$;
    }

    public static final Object container$ImageDownloader$Executor$$anon$2$$_$apply$$anonfun$1(Function0 f$1) {
        return f$1.apply();
    }

    public static final Object container$ImageDownloader$Executor$$anon$3$$_$apply$$anonfun$2(Function0 f$2) {
        return f$2.apply();
    }

    private final int $anonfun$1() {
        return 0;
    }

    private final String $anonfun$2(RegistryImage dockerImage$1, Time timeout$1, Option proxy$1) {
        return Registry$.MODULE$.downloadManifest(dockerImage$1, timeout$1, (Option<HttpHost>)proxy$1.map((Function1 & Serializable)httpProxy -> ImageDownloader$HttpProxy$.MODULE$.toHost((ImageDownloader.HttpProxy)httpProxy)));
    }

    private final Json $anonfun$5() {
        return Json$.MODULE$.Null();
    }

    private final None$ $anonfun$8$$anonfun$1() {
        return None$.MODULE$;
    }

    private final IterableOnce $anonfun$8() {
        return package$.MODULE$.Iterator().continually(this::$anonfun$8$$anonfun$1);
    }

    private final void $anonfun$10$$anonfun$1$$anonfun$1(RegistryImage dockerImage$4, Time timeout$4, Option proxy$4, String hash$2, better.files.File tmpLayerDir$1) {
        Registry$.MODULE$.downloadBlob(dockerImage$4, Registry$Layer$.MODULE$.apply(hash$2), tmpLayerDir$1.$div("layer.tar"), timeout$4, (Option<HttpHost>)proxy$4.map((Function1 & Serializable)httpProxy -> ImageDownloader$HttpProxy$.MODULE$.toHost((ImageDownloader.HttpProxy)httpProxy)));
    }

    private final Tuple2 $anonfun$10$$anonfun$1$$anonfun$2(better.files.File imageDirectoryValue$3, String hash$3, better.files.File idFile$1, better.files.File tmpLayerDir$2, String layerHash$1) {
        if (!idFile$1.exists(idFile$1.exists$default$1())) {
            better.files.File layerPath = imageDirectoryValue$3.$div(layerHash$1);
            Object object = !layerPath.exists(layerPath.exists$default$1()) ? Files.move(tmpLayerDir$2.path(), layerPath.path(), (CopyOption[])Arrays$.MODULE$.seqToArray(File.CopyOptions$.MODULE$.apply(false), CopyOption.class)) : tmpLayerDir$2.delete(tmpLayerDir$2.delete$default$1(), tmpLayerDir$2.delete$default$2());
            idFile$1.createFile(idFile$1.createFile$default$1());
            idFile$1.write(layerHash$1, idFile$1.write$default$2(layerHash$1), idFile$1.write$default$3(layerHash$1));
            return Tuple2$.MODULE$.apply((Object)hash$3, (Object)Some$.MODULE$.apply((Object)layerHash$1));
        }
        tmpLayerDir$2.delete(tmpLayerDir$2.delete$default$1(), tmpLayerDir$2.delete$default$2());
        return Tuple2$.MODULE$.apply((Object)hash$3, (Object)Some$.MODULE$.apply((Object)idFile$1.contentAsString(idFile$1.contentAsString$default$1())));
    }

    private final Tuple2 $anonfun$10$$anonfun$1(RegistryImage dockerImage$3, Time timeout$3, Option proxy$3, int retryCount$2, better.files.File tmpDirectory$2, better.files.File imageDirectoryValue$2, better.files.File idsDirectory$2, String hash$1, String id$1, boolean ignore$1, Option v1compat$1) {
        better.files.File idFile = idsDirectory$2.$div(id$1);
        if (!ignore$1) {
            if (!idFile.exists(idFile.exists$default$1())) {
                String dirName = UUID.randomUUID().toString();
                better.files.File tmpLayerDir = tmpDirectory$2.$div(dirName);
                tmpLayerDir.createDirectories(tmpLayerDir.createDirectories$default$1(), tmpLayerDir.createDirectories$default$2());
                better.files.File file = tmpLayerDir.$div("VERSION");
                file.appendLine("1.0", file.appendLine$default$2("1.0"));
                Retry$.MODULE$.retry(retryCount$2, (Function0 & Serializable)() -> {
                    this.$anonfun$10$$anonfun$1$$anonfun$1(dockerImage$3, timeout$3, proxy$3, hash$1, tmpLayerDir);
                    return BoxedUnit.UNIT;
                });
                String layerHash = Hash$.MODULE$.sha256(Hash$HashSource$.MODULE$.fromFile(tmpLayerDir.$div("layer.tar").toJava()), Hash$.MODULE$.sha256$default$2());
                better.files.File file2 = better.files.package$.MODULE$.StringExtensions(tmpLayerDir.pathAsString()).$div("json");
                if (!file2.exists(file2.exists$default$1()) && v1compat$1.nonEmpty()) {
                    better.files.File file3 = tmpLayerDir.$div("json");
                    String string = (String)v1compat$1.get();
                    file3.appendLine(string, file3.appendLine$default$2(string));
                }
                File file4 = idsDirectory$2.toJava();
                return (Tuple2)lock$.MODULE$.withLockInDirectory(file4, () -> this.$anonfun$10$$anonfun$1$$anonfun$2(imageDirectoryValue$2, hash$1, idFile, tmpLayerDir, layerHash), lock$.MODULE$.withLockInDirectory$default$3(file4));
            }
            return Tuple2$.MODULE$.apply((Object)hash$1, (Object)Some$.MODULE$.apply((Object)idFile.contentAsString(idFile.contentAsString$default$1())));
        }
        return Tuple2$.MODULE$.apply((Object)hash$1, (Object)None$.MODULE$);
    }
}

