/*
 * Decompiled with CFR 0.152.
 */
package gridscale.local;

import gridscale.local.LocalExecutionError$;
import gridscale.local.LocalIOError$;
import gridscale.package;
import gridscale.tools.shell.BashShell$;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.sys.process.Process;
import scala.sys.process.ProcessIO;
import scala.sys.process.package$;

public final class Local$
implements Serializable {
    public static final Local$ MODULE$ = new Local$();

    private Local$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Local$.class);
    }

    public package.ExecutionResult execute(String cmd) {
        package.ExecutionResult executionResult;
        try {
            StringBuilder out = new StringBuilder();
            StringBuilder err = new StringBuilder();
            Tuple2 tuple2 = BashShell$.MODULE$.localBashCommand(cmd);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String shell = (String)tuple2._1();
            String commands = (String)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)shell, (Object)commands);
            String shell2 = (String)tuple22._1();
            String commands2 = (String)tuple22._2();
            ProcessIO io = new ProcessIO((Function1)(JProcedure1 & Serializable)stdin -> {
                stdin.write(commands2.getBytes());
                stdin.close();
            }, (Function1)(JProcedure1 & Serializable)stdout -> out.append(Source$.MODULE$.fromInputStream(stdout, Codec$.MODULE$.fallbackSystemCodec()).mkString("")), (Function1)(JProcedure1 & Serializable)stderr -> err.append(Source$.MODULE$.fromInputStream(stderr, Codec$.MODULE$.fallbackSystemCodec()).mkString("")));
            Process proc = package$.MODULE$.stringToProcess(shell2).run(io);
            executionResult = package.ExecutionResult$.MODULE$.apply(proc.exitValue(), out.mkString(), err.mkString());
        }
        catch (Throwable e) {
            throw LocalExecutionError$.MODULE$.apply("Error executing " + cmd + " on local host", e);
        }
        return executionResult;
    }

    public void writeBytes(byte[] bytes, String path) {
        try {
            Files.write(Paths.get(path, new String[0]), bytes, new OpenOption[0]);
        }
        catch (Throwable e) {
            throw LocalIOError$.MODULE$.apply("Could not write file to path " + path + " on local host", e);
        }
    }

    public void writeFile(Function0<InputStream> is, String path) {
        try (InputStream ois = (InputStream)is.apply();){
            Files.copy(ois, Paths.get(path, new String[0]), new CopyOption[0]);
        }
        catch (Throwable e) {
            throw LocalIOError$.MODULE$.apply("Could not write file to path " + path + " on local host", e);
        }
    }

    public <T> T readFile(String path, Function1<InputStream, T> f) {
        Object object;
        try (FileInputStream source = new FileInputStream(new File(path));){
            object = f.apply((Object)source);
        }
        return (T)object;
    }

    public void rmFile(String path) {
        try {
            Files.delete(Paths.get(path, new String[0]));
        }
        catch (Throwable e) {
            throw LocalIOError$.MODULE$.apply("Could not delete file " + path + " on local host", e);
        }
    }

    public String home() {
        String string;
        try {
            string = System.getProperty("user.home");
        }
        catch (Throwable e) {
            throw LocalIOError$.MODULE$.apply("Could not determine homme on local host", e);
        }
        return string;
    }

    public boolean exists(String path) {
        boolean bl;
        try {
            bl = new File(path).exists();
        }
        catch (Throwable e) {
            throw LocalIOError$.MODULE$.apply("Could not test if " + path + " exists on local host", e);
        }
        return bl;
    }

    public List<package.ListEntry> list(String path) {
        List list;
        try {
            Object object = Predef$.MODULE$.refArrayOps((Object[])new File(path).listFiles());
            list = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)f -> {
                package.FileType$.Link$ ftype = Files.isSymbolicLink(f.toPath()) ? package.FileType$.Link$.MODULE$ : (package.FileType)(f.isDirectory() ? package.FileType$.Directory$.MODULE$ : package.FileType$.File$.MODULE$);
                return package.ListEntry$.MODULE$.apply(f.getName(), (package.FileType)ftype, (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)f.lastModified())));
            }, ClassTag$.MODULE$.apply(package.ListEntry.class))).toList();
        }
        catch (Throwable e) {
            throw LocalIOError$.MODULE$.apply("Could not list directory " + path + " on local host", e);
        }
        return list;
    }

    public void makeDir(String path) {
        try {
            new File(path).mkdirs();
        }
        catch (Throwable e) {
            throw LocalIOError$.MODULE$.apply("Could not make directory " + path + " on local host", e);
        }
    }

    public void rmDir(String path) {
        try {
            this.delete$1(new File(path));
        }
        catch (Throwable e) {
            throw LocalIOError$.MODULE$.apply("Could not removet directory " + path + " on local host", e);
        }
    }

    public Path mv(String from, String to) {
        Path path;
        try {
            path = Files.move(Paths.get(from, new String[0]), Paths.get(to, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable e) {
            throw LocalIOError$.MODULE$.apply("Could not move " + from + " to " + to + " on local host", e);
        }
        return path;
    }

    public Path link(String target, String link, boolean defaultOnCopy) {
        return this.createLink$1(defaultOnCopy, Paths.get(target, new String[0]), Paths.get(link, new String[0]));
    }

    public boolean link$default$3() {
        return false;
    }

    private final void delete$1(File f2) {
        if (f2.isDirectory()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])f2.listFiles());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)f -> this.delete$1((File)f));
        }
        f2.delete();
    }

    private final File getParentFileSafe$1(File file) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            if (file.isAbsolute()) {
                return file;
            }
            return new File(".");
        }
        File f = file2;
        return f;
    }

    private final Path unsupported$1(Path target$1, Path link$1) {
        Path fullTargetPath = target$1.isAbsolute() ? target$1 : Paths.get(this.getParentFileSafe$1(link$1.toFile()).getPath(), target$1.toFile().getPath());
        Files.copy(fullTargetPath, link$1, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        return link$1;
    }

    private final Path createLink$1(boolean defaultOnCopy$1, Path target, Path link) {
        Path path;
        try {
            path = Files.createSymbolicLink(link, target, new FileAttribute[0]);
        }
        catch (UnsupportedOperationException e) {
            if (defaultOnCopy$1) {
                path = this.unsupported$1(target, link);
            }
            throw e;
        }
        catch (FileAlreadyExistsException e) {
            throw e;
        }
        catch (FileSystemException e) {
            if (defaultOnCopy$1) {
                path = this.unsupported$1(target, link);
            }
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        return path;
    }
}

