/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.Macro;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.Date;

final class BuiltinVariable
extends Expression {
    static final String TEMPLATE_NAME = "template_name";
    static final String NAMESPACE = "namespace";
    static final String MAIN = "main";
    static final String GLOBALS = "globals";
    static final String LOCALS = "locals";
    static final String DATA_MODEL = "data_model";
    static final String LANG = "lang";
    static final String LOCALE = "locale";
    static final String CURRENT_NODE = "current_node";
    static final String NODE = "node";
    static final String PASS = "pass";
    static final String VARS = "vars";
    static final String VERSION = "version";
    static final String ERROR = "error";
    static final String OUTPUT_ENCODING = "output_encoding";
    static final String URL_ESCAPING_CHARSET = "url_escaping_charset";
    static final String NOW = "now";
    private final String name;

    BuiltinVariable(String name2) throws ParseException {
        this.name = name2 = name2.intern();
        if (name2 != TEMPLATE_NAME && name2 != NAMESPACE && name2 != MAIN && name2 != GLOBALS && name2 != LOCALS && name2 != LANG && name2 != LOCALE && name2 != DATA_MODEL && name2 != CURRENT_NODE && name2 != NODE && name2 != PASS && name2 != VARS && name2 != VERSION && name2 != OUTPUT_ENCODING && name2 != URL_ESCAPING_CHARSET && name2 != ERROR && name2 != NOW) {
            throw new ParseException("Unknown built-in variable: " + name2, this);
        }
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        if (this.name == NAMESPACE) {
            return env.getCurrentNamespace();
        }
        if (this.name == MAIN) {
            return env.getMainNamespace();
        }
        if (this.name == GLOBALS) {
            return env.getGlobalVariables();
        }
        if (this.name == LOCALS) {
            Macro.Context ctx = env.getCurrentMacroContext();
            return ctx == null ? null : ctx.getLocals();
        }
        if (this.name == DATA_MODEL) {
            return env.getDataModel();
        }
        if (this.name == VARS) {
            return new VarsHash(env);
        }
        if (this.name == LOCALE) {
            return new SimpleScalar(env.getLocale().toString());
        }
        if (this.name == LANG) {
            return new SimpleScalar(env.getLocale().getLanguage());
        }
        if (this.name == CURRENT_NODE || this.name == NODE) {
            return env.getCurrentVisitorNode();
        }
        if (this.name == TEMPLATE_NAME) {
            return new SimpleScalar(env.getTemplate().getName());
        }
        if (this.name == PASS) {
            return Macro.DO_NOTHING_MACRO;
        }
        if (this.name == VERSION) {
            return new SimpleScalar(Configuration.getVersionNumber());
        }
        if (this.name == OUTPUT_ENCODING) {
            String s = env.getOutputEncoding();
            return s != null ? new SimpleScalar(s) : null;
        }
        if (this.name == URL_ESCAPING_CHARSET) {
            String s = env.getURLEscapingCharset();
            return s != null ? new SimpleScalar(s) : null;
        }
        if (this.name == ERROR) {
            return new SimpleScalar(env.getCurrentRecoveredErrorMesssage());
        }
        if (this.name == NOW) {
            return new SimpleDate(new Date(), 3);
        }
        throw new TemplateException("Invalid built-in variable: " + this, env);
    }

    public String toString() {
        return "." + this.name;
    }

    public String getCanonicalForm() {
        return "." + this.name;
    }

    boolean isLiteral() {
        return false;
    }

    Expression _deepClone(String name2, Expression subst) {
        return this;
    }

    static class VarsHash
    implements TemplateHashModel {
        Environment env;

        VarsHash(Environment env) {
            this.env = env;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            return this.env.getVariable(key);
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

