/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.LocalContext;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateObject;
import freemarker.core.TextBlock;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.utility.Collections12;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class Macro
extends TemplateElement
implements TemplateModel {
    private final String name;
    private final String[] argumentNames;
    private Map args;
    private String catchAll;
    boolean isFunction;
    static final Macro DO_NOTHING_MACRO = new Macro(".pass", Collections.EMPTY_LIST, Collections12.EMPTY_MAP, TextBlock.EMPTY_BLOCK);

    Macro(String name2, List argumentNames, Map args, TemplateElement nestedBlock) {
        this.name = name2;
        this.argumentNames = argumentNames.toArray(new String[argumentNames.size()]);
        this.args = args;
        this.nestedBlock = nestedBlock;
    }

    public String getCatchAll() {
        return this.catchAll;
    }

    public void setCatchAll(String value2) {
        this.catchAll = value2;
    }

    public String[] getArgumentNames() {
        return (String[])this.argumentNames.clone();
    }

    String[] getArgumentNamesInternal() {
        return this.argumentNames;
    }

    boolean hasArgNamed(String name2) {
        return this.args.containsKey(name2);
    }

    public String getName() {
        return this.name;
    }

    void accept(Environment env) {
        env.visitMacroDef(this);
    }

    public String getCanonicalForm() {
        String directiveName = this.isFunction ? "function" : "macro";
        StringBuffer buf = new StringBuffer("<#");
        buf.append(directiveName);
        buf.append(' ');
        buf.append(this.name);
        buf.append('(');
        int size = this.argumentNames.length;
        for (int i = 0; i < size; ++i) {
            buf.append(this.argumentNames[i]);
            if (i == size - 1) continue;
            buf.append(",");
        }
        buf.append(")>");
        if (this.nestedBlock != null) {
            buf.append(this.nestedBlock.getCanonicalForm());
        }
        buf.append("</#");
        buf.append(directiveName);
        buf.append('>');
        return buf.toString();
    }

    public String getDescription() {
        return (this.isFunction() ? "function " : "macro ") + this.name;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    class Context
    implements LocalContext {
        Environment.Namespace localVars;
        TemplateElement body;
        Environment.Namespace bodyNamespace;
        List bodyParameterNames;
        Context prevMacroContext;
        ArrayList prevLocalContextStack;

        Context(Environment env, TemplateElement body, List bodyParameterNames) {
            this.localVars = env.new Environment.Namespace();
            this.prevMacroContext = env.getCurrentMacroContext();
            this.bodyNamespace = env.getCurrentNamespace();
            this.prevLocalContextStack = env.getLocalContextStack();
            this.body = body;
            this.bodyParameterNames = bodyParameterNames;
        }

        Macro getMacro() {
            return Macro.this;
        }

        void runMacro(Environment env) throws TemplateException, IOException {
            this.sanityCheck(env);
            if (Macro.this.nestedBlock != null) {
                env.visit(Macro.this.nestedBlock);
            }
        }

        void sanityCheck(Environment env) throws TemplateException {
            InvalidReferenceException firstReferenceException;
            Expression firstUnresolvedExpression;
            boolean hasUnresolvedArg;
            boolean resolvedAnArg;
            do {
                firstUnresolvedExpression = null;
                firstReferenceException = null;
                hasUnresolvedArg = false;
                resolvedAnArg = false;
                for (int i = 0; i < Macro.this.argumentNames.length; ++i) {
                    String argName = Macro.this.argumentNames[i];
                    if (this.localVars.get(argName) != null) continue;
                    Expression valueExp = (Expression)Macro.this.args.get(argName);
                    if (valueExp != null) {
                        try {
                            TemplateModel tm = valueExp.getAsTemplateModel(env);
                            if (tm == null) {
                                if (hasUnresolvedArg) continue;
                                firstUnresolvedExpression = valueExp;
                                hasUnresolvedArg = true;
                                continue;
                            }
                            this.localVars.put(argName, tm);
                            resolvedAnArg = true;
                        }
                        catch (InvalidReferenceException e) {
                            if (hasUnresolvedArg) continue;
                            hasUnresolvedArg = true;
                            firstReferenceException = e;
                        }
                        continue;
                    }
                    throw new TemplateException("Error executing macro: " + Macro.this.name + "\nrequired parameter: " + argName + " is not specified.", env);
                }
            } while (resolvedAnArg && hasUnresolvedArg);
            if (hasUnresolvedArg) {
                if (firstReferenceException != null) {
                    throw firstReferenceException;
                }
                TemplateObject.assertNonNull(null, firstUnresolvedExpression, env);
            }
        }

        public TemplateModel getLocalVariable(String name2) throws TemplateModelException {
            return this.localVars.get(name2);
        }

        Environment.Namespace getLocals() {
            return this.localVars;
        }

        void setLocalVar(String name2, TemplateModel var) {
            this.localVars.put(name2, var);
        }

        public Collection getLocalVariableNames() throws TemplateModelException {
            HashSet<String> result = new HashSet<String>();
            TemplateModelIterator it = this.localVars.keys().iterator();
            while (it.hasNext()) {
                result.add(it.next().toString());
            }
            return result;
        }
    }
}

