/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;

final class NumberLiteral
extends Expression
implements TemplateNumberModel {
    private final Number value;

    public NumberLiteral(Number value2) {
        this.value = value2;
    }

    TemplateModel _getAsTemplateModel(Environment env) {
        return new SimpleNumber(this.value);
    }

    public String getStringValue(Environment env) {
        return env.formatNumber(this.value);
    }

    public Number getAsNumber() {
        return this.value;
    }

    String getName() {
        return "the number: '" + this.value + "'";
    }

    public String getCanonicalForm() {
        return this.value.toString();
    }

    boolean isLiteral() {
        return true;
    }

    Expression _deepClone(String name2, Expression subst) {
        return new NumberLiteral(this.value);
    }
}

