/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.CacheStorage;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class MruCacheStorage
implements CacheStorage {
    private final MruEntry strongHead = new MruEntry();
    private final MruEntry softHead = new MruEntry();
    private final Map map;
    private final ReferenceQueue refQueue;
    private final int maxStrongSize;
    private final int maxSoftSize;
    private int strongSize;
    private int softSize;

    public MruCacheStorage(int maxStrongSize, int maxSoftSize) {
        this.softHead.linkAfter(this.strongHead);
        this.map = new HashMap();
        this.refQueue = new ReferenceQueue();
        this.strongSize = 0;
        this.softSize = 0;
        if (maxStrongSize < 0) {
            throw new IllegalArgumentException("maxStrongSize < 0");
        }
        if (maxSoftSize < 0) {
            throw new IllegalArgumentException("maxSoftSize < 0");
        }
        this.maxStrongSize = maxStrongSize;
        this.maxSoftSize = maxSoftSize;
    }

    public Object get(Object key) {
        this.removeClearedReferences();
        MruEntry entry2 = (MruEntry)this.map.get(key);
        if (entry2 == null) {
            return null;
        }
        this.relinkEntryAfterStrongHead(entry2, null);
        Object value2 = entry2.getValue();
        if (value2 instanceof MruReference) {
            return ((MruReference)value2).get();
        }
        return value2;
    }

    public void put(Object key, Object value2) {
        this.removeClearedReferences();
        MruEntry entry2 = (MruEntry)this.map.get(key);
        if (entry2 == null) {
            entry2 = new MruEntry(key, value2);
            this.map.put(key, entry2);
            this.linkAfterStrongHead(entry2);
        } else {
            this.relinkEntryAfterStrongHead(entry2, value2);
        }
    }

    public void remove(Object key) {
        this.removeClearedReferences();
        this.removeInternal(key);
    }

    private void removeInternal(Object key) {
        MruEntry entry2 = (MruEntry)this.map.remove(key);
        if (entry2 != null) {
            this.unlinkEntryAndInspectIfSoft(entry2);
        }
    }

    public void clear() {
        this.strongHead.makeHead();
        this.softHead.linkAfter(this.strongHead);
        this.map.clear();
        this.softSize = 0;
        this.strongSize = 0;
        while (this.refQueue.poll() != null) {
        }
    }

    private void relinkEntryAfterStrongHead(MruEntry entry2, Object newValue) {
        if (this.unlinkEntryAndInspectIfSoft(entry2) && newValue == null) {
            MruReference mref = (MruReference)entry2.getValue();
            Object strongValue = mref.get();
            if (strongValue != null) {
                entry2.setValue(strongValue);
                this.linkAfterStrongHead(entry2);
            } else {
                this.map.remove(mref.getKey());
            }
        } else {
            if (newValue != null) {
                entry2.setValue(newValue);
            }
            this.linkAfterStrongHead(entry2);
        }
    }

    private void linkAfterStrongHead(MruEntry entry2) {
        entry2.linkAfter(this.strongHead);
        if (this.strongSize == this.maxStrongSize) {
            MruEntry lruStrong = this.softHead.getPrevious();
            if (lruStrong != this.strongHead) {
                lruStrong.unlink();
                if (this.maxSoftSize > 0) {
                    lruStrong.linkAfter(this.softHead);
                    lruStrong.setValue(new MruReference(lruStrong, this.refQueue));
                    if (this.softSize == this.maxSoftSize) {
                        MruEntry lruSoft = this.strongHead.getPrevious();
                        lruSoft.unlink();
                        this.map.remove(lruSoft.getKey());
                    } else {
                        ++this.softSize;
                    }
                } else {
                    this.map.remove(lruStrong.getKey());
                }
            }
        } else {
            ++this.strongSize;
        }
    }

    private boolean unlinkEntryAndInspectIfSoft(MruEntry entry2) {
        entry2.unlink();
        if (entry2.getValue() instanceof MruReference) {
            --this.softSize;
            return true;
        }
        --this.strongSize;
        return false;
    }

    private void removeClearedReferences() {
        MruReference ref;
        while ((ref = (MruReference)this.refQueue.poll()) != null) {
            this.removeInternal(ref.getKey());
        }
    }

    private static class MruReference
    extends SoftReference {
        private final Object key;

        MruReference(MruEntry entry2, ReferenceQueue queue) {
            super(entry2.getValue(), queue);
            this.key = entry2.getKey();
        }

        Object getKey() {
            return this.key;
        }
    }

    private static final class MruEntry {
        private MruEntry prev;
        private MruEntry next;
        private final Object key;
        private Object value;

        MruEntry() {
            this.makeHead();
            this.value = null;
            this.key = null;
        }

        MruEntry(Object key, Object value2) {
            this.key = key;
            this.value = value2;
        }

        Object getKey() {
            return this.key;
        }

        Object getValue() {
            return this.value;
        }

        void setValue(Object value2) {
            this.value = value2;
        }

        MruEntry getPrevious() {
            return this.prev;
        }

        void linkAfter(MruEntry entry2) {
            this.next = entry2.next;
            entry2.next = this;
            this.prev = entry2;
            this.next.prev = this;
        }

        void unlink() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
            this.prev = null;
            this.next = null;
        }

        void makeHead() {
            this.prev = this.next = this;
        }
    }
}

