/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.FMParser;
import freemarker.core.FMParserTokenManager;
import freemarker.core.ParseException;
import freemarker.core.SimpleCharStream;
import freemarker.core.TemplateElement;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;

final class StringLiteral
extends Expression
implements TemplateScalarModel {
    private final String value;
    private TemplateElement interpolatedOutput;

    StringLiteral(String value2) {
        this.value = value2;
    }

    void checkInterpolation() throws ParseException {
        if (this.value.length() > 3 && (this.value.indexOf("${") >= 0 || this.value.indexOf("#{") >= 0)) {
            SimpleCharStream scs = new SimpleCharStream(new StringReader(this.value), this.beginLine, this.beginColumn + 1, this.value.length());
            FMParserTokenManager token_source = new FMParserTokenManager(scs);
            token_source.onlyTextOutput = true;
            FMParser parser = new FMParser(token_source);
            parser.template = this.getTemplate();
            try {
                this.interpolatedOutput = parser.FreeMarkerText();
            }
            catch (ParseException e) {
                e.setTemplateName(this.getTemplate().getName());
                throw e;
            }
            this.constantValue = null;
        }
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        return new SimpleScalar(this.getStringValue(env));
    }

    public String getAsString() {
        return this.value;
    }

    String getStringValue(Environment env) throws TemplateException {
        if (this.interpolatedOutput == null) {
            return this.value;
        }
        TemplateExceptionHandler teh = env.getTemplateExceptionHandler();
        env.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            String string2 = env.renderElementToString(this.interpolatedOutput);
            return string2;
        }
        catch (IOException ioe) {
            throw new TemplateException(ioe, env);
        }
        finally {
            env.setTemplateExceptionHandler(teh);
        }
    }

    public String getCanonicalForm() {
        return "\"" + StringLiteral.escapeString(this.value) + "\"";
    }

    boolean isLiteral() {
        return this.interpolatedOutput == null;
    }

    Expression _deepClone(String name2, Expression subst) {
        StringLiteral cloned = new StringLiteral(this.value);
        cloned.interpolatedOutput = this.interpolatedOutput;
        return cloned;
    }

    private static String escapeString(String s) {
        if (s.indexOf(34) == -1) {
            return s;
        }
        StringTokenizer st = new StringTokenizer(s, "\"", true);
        StringBuffer buf = new StringBuffer();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("\"")) {
                buf.append('\\');
            }
            buf.append(tok);
        }
        return buf.toString();
    }
}

