/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.WrappingTemplateModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SimpleSequence
extends WrappingTemplateModel
implements TemplateSequenceModel,
Serializable {
    protected final List list;
    private List unwrappedList;

    public SimpleSequence() {
        this((ObjectWrapper)null);
    }

    public SimpleSequence(int capacity) {
        this.list = new ArrayList(capacity);
    }

    public SimpleSequence(Collection collection) {
        this(collection, null);
    }

    public SimpleSequence(TemplateCollectionModel tcm) throws TemplateModelException {
        ArrayList<TemplateModel> alist = new ArrayList<TemplateModel>();
        TemplateModelIterator it = tcm.iterator();
        while (it.hasNext()) {
            alist.add(it.next());
        }
        alist.trimToSize();
        this.list = alist;
    }

    public SimpleSequence(ObjectWrapper wrapper) {
        super(wrapper);
        this.list = new ArrayList();
    }

    public SimpleSequence(Collection collection, ObjectWrapper wrapper) {
        super(wrapper);
        this.list = new ArrayList(collection);
    }

    public void add(Object obj) {
        this.list.add(obj);
        this.unwrappedList = null;
    }

    public void add(boolean b) {
        if (b) {
            this.add(TemplateBooleanModel.TRUE);
        } else {
            this.add(TemplateBooleanModel.FALSE);
        }
    }

    public List toList() throws TemplateModelException {
        if (this.unwrappedList == null) {
            Class<?> listClass = this.list.getClass();
            List result = null;
            try {
                result = (List)listClass.newInstance();
            }
            catch (Exception e) {
                throw new TemplateModelException("Error instantiating an object of type " + listClass.getName() + "\n" + e.getMessage());
            }
            BeansWrapper bw = BeansWrapper.getDefaultInstance();
            for (int i = 0; i < this.list.size(); ++i) {
                Object elem = this.list.get(i);
                if (elem instanceof TemplateModel) {
                    elem = bw.unwrap((TemplateModel)elem);
                }
                result.add(elem);
            }
            this.unwrappedList = result;
        }
        return this.unwrappedList;
    }

    public TemplateModel get(int i) throws TemplateModelException {
        try {
            Object value2 = this.list.get(i);
            if (value2 instanceof TemplateModel) {
                return (TemplateModel)value2;
            }
            TemplateModel tm = this.wrap(value2);
            this.list.set(i, tm);
            return tm;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public int size() {
        return this.list.size();
    }

    public SimpleSequence synchronizedWrapper() {
        return new SynchronizedSequence();
    }

    public String toString() {
        return this.list.toString();
    }

    private class SynchronizedSequence
    extends SimpleSequence {
        private SynchronizedSequence() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Object obj) {
            SimpleSequence simpleSequence = SimpleSequence.this;
            synchronized (simpleSequence) {
                SimpleSequence.this.add(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemplateModel get(int i) throws TemplateModelException {
            SimpleSequence simpleSequence = SimpleSequence.this;
            synchronized (simpleSequence) {
                return SimpleSequence.this.get(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            SimpleSequence simpleSequence = SimpleSequence.this;
            synchronized (simpleSequence) {
                return SimpleSequence.this.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List toList() throws TemplateModelException {
            SimpleSequence simpleSequence = SimpleSequence.this;
            synchronized (simpleSequence) {
                return SimpleSequence.this.toList();
            }
        }
    }
}

