/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j62056;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.openmuc.j62056.DataSet;

public class Connection {
    private final String serialPortName;
    private SerialPort serialPort;
    private final boolean handleEcho;
    private final int baudRateChangeDelay;
    private int timeout = 5000;
    private DataOutputStream os;
    private DataInputStream is;
    private static final byte[] REQUEST_MESSAGE = new byte[]{47, 63, 33, 13, 10};
    private static final byte[] ACKNOWLEDGE = new byte[]{6, 48, 48, 48, 13, 10};
    private static final int INPUT_BUFFER_LENGTH = 1024;
    private final byte[] buffer = new byte[1024];
    private static final Charset charset = Charset.forName("US-ASCII");
    private static final int SLEEP_INTERVAL = 100;

    public Connection(String serialPort, boolean handleEcho, int baudRateChangeDelay) {
        if (serialPort == null) {
            throw new IllegalArgumentException("serialPort may not be NULL");
        }
        this.serialPortName = serialPort;
        this.handleEcho = handleEcho;
        this.baudRateChangeDelay = baudRateChangeDelay;
    }

    public Connection(String serialPort) {
        this(serialPort, false, 0);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void open() throws IOException {
        CommPort commPort;
        CommPortIdentifier portIdentifier;
        try {
            portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.serialPortName);
        }
        catch (NoSuchPortException e) {
            throw new IOException("Serial port with given name does not exist", e);
        }
        if (portIdentifier.isCurrentlyOwned()) {
            throw new IOException("Serial port is currently in use.");
        }
        try {
            commPort = portIdentifier.open(this.getClass().getName(), 2000);
        }
        catch (PortInUseException e) {
            throw new IOException("Serial port is currently in use.", e);
        }
        if (!(commPort instanceof SerialPort)) {
            commPort.close();
            throw new IOException("The specified CommPort is not a serial port");
        }
        this.serialPort = (SerialPort)commPort;
        try {
            this.os = new DataOutputStream(this.serialPort.getOutputStream());
            this.is = new DataInputStream(this.serialPort.getInputStream());
        }
        catch (IOException e) {
            this.serialPort.close();
            this.serialPort = null;
            throw new IOException("Error getting input or output or input stream from serial port", e);
        }
    }

    public void close() {
        if (this.serialPort == null) {
            return;
        }
        this.serialPort.close();
        this.serialPort = null;
    }

    public List<DataSet> read() throws IOException, TimeoutException {
        int endIndex;
        int index;
        int timeval;
        if (this.serialPort == null) {
            throw new IllegalStateException("Connection is not open.");
        }
        try {
            this.serialPort.setSerialPortParams(300, 7, 1, 2);
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException("Unable to set the given serial comm parameters", e);
        }
        this.os.write(REQUEST_MESSAGE);
        this.os.flush();
        boolean readSuccessful = false;
        int numBytesReadTotal = 0;
        for (timeval = 0; this.timeout == 0 || timeval < this.timeout; timeval += 100) {
            if (this.is.available() > 0) {
                int numBytesRead = this.is.read(this.buffer, numBytesReadTotal, 1024 - numBytesReadTotal);
                numBytesReadTotal += numBytesRead;
                if (numBytesRead > 0) {
                    timeval = 0;
                }
                if ((this.handleEcho && numBytesReadTotal > 11 || !this.handleEcho && numBytesReadTotal > 6) && this.buffer[numBytesReadTotal - 2] == 13 && this.buffer[numBytesReadTotal - 1] == 10) {
                    readSuccessful = true;
                    break;
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        int offset = 0;
        if (this.handleEcho) {
            offset = 5;
        }
        if (numBytesReadTotal == offset) {
            throw new TimeoutException();
        }
        if (!readSuccessful) {
            throw new IOException("Timeout while listening for Identification Message");
        }
        byte baudRateSetting = this.buffer[offset + 4];
        int baudRate = this.getBaudRate(baudRateSetting);
        String identification = new String(this.buffer, offset + 5, numBytesReadTotal - offset - 7, charset);
        if (baudRate == -1) {
            throw new IOException("Syntax error in identification message received: unknown baud rate received.");
        }
        Connection.ACKNOWLEDGE[2] = baudRateSetting;
        this.os.write(ACKNOWLEDGE);
        this.os.flush();
        if (this.handleEcho) {
            readSuccessful = false;
            numBytesReadTotal = 0;
            while (this.timeout == 0 || timeval < this.timeout) {
                if (this.is.available() > 0) {
                    int numBytesRead = this.is.read(this.buffer, numBytesReadTotal, ACKNOWLEDGE.length - numBytesReadTotal);
                    numBytesReadTotal += numBytesRead;
                    if (numBytesRead > 0) {
                        timeval = 0;
                    }
                    if (numBytesReadTotal == ACKNOWLEDGE.length) {
                        readSuccessful = true;
                        break;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                timeval += 100;
            }
        }
        if (this.baudRateChangeDelay > 0) {
            try {
                Thread.sleep(this.baudRateChangeDelay);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        try {
            this.serialPort.setSerialPortParams(baudRate, 7, 1, 2);
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException("Serial Port does not support " + baudRate + "bd 8N1");
        }
        readSuccessful = false;
        numBytesReadTotal = 0;
        while (this.timeout == 0 || timeval < this.timeout) {
            if (this.is.available() > 0) {
                int numBytesRead = this.is.read(this.buffer, numBytesReadTotal, 1024 - numBytesReadTotal);
                numBytesReadTotal += numBytesRead;
                if (numBytesRead > 0) {
                    timeval = 0;
                }
                if (numBytesReadTotal > 4 && this.buffer[numBytesReadTotal - 3] == 33 || numBytesReadTotal > 7 && this.buffer[numBytesReadTotal - 5] == 33) {
                    readSuccessful = true;
                    break;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            timeval += 100;
        }
        if (!readSuccessful) {
            throw new IOException("Timeout while listening for Data Message");
        }
        if (this.buffer[numBytesReadTotal - 2] == 3) {
            if (numBytesReadTotal < 8) {
                throw new IOException("Data message does not have minimum length of 8.");
            }
            index = 1;
            endIndex = numBytesReadTotal - 5;
            if (this.buffer[0] != 2) {
                throw new IOException("STX (0x02) character is expected but not received as first byte of data message.");
            }
        } else {
            if (numBytesReadTotal < 5) {
                throw new IOException("Data message does not have minimum length of 5.");
            }
            index = 0;
            endIndex = numBytesReadTotal - 3;
        }
        if (this.buffer[endIndex + 1] != 13) {
            throw new IOException("CR (0x0D) character is expected but not received after data block of data message.");
        }
        if (this.buffer[endIndex + 2] != 10) {
            throw new IOException("LF (0x0A) character is expected but not received after data block of data message.");
        }
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        dataSets.add(new DataSet(identification, "", ""));
        while (index != endIndex) {
            String id = null;
            for (int i = index; i < endIndex - 1; ++i) {
                if (this.buffer[i] != 40) continue;
                id = new String(this.buffer, index, i - index, charset);
                index = i + 1;
                break;
            }
            if (id == null) {
                throw new IOException("'(' (0x28) character is expected but not received inside data block of data message.");
            }
            String value = "";
            String unit = "";
            block17: for (int i = index; i < endIndex; ++i) {
                if (this.buffer[i] == 42) {
                    if (i > index) {
                        value = new String(this.buffer, index, i - index, charset);
                    }
                    for (int j = index = i + 1; j < endIndex; ++j) {
                        if (this.buffer[j] != 41) continue;
                        unit = new String(this.buffer, index, j - index, charset);
                        index = j + 1;
                        break block17;
                    }
                    break;
                }
                if (this.buffer[i] != 41) continue;
                if (i > index) {
                    value = new String(this.buffer, index, i - index, charset);
                }
                index = i + 1;
                break;
            }
            if (this.buffer[index - 1] != 41) {
                throw new IOException("')' (0x29) character is expected but not received inside data block of data message.");
            }
            dataSets.add(new DataSet(id, value, unit));
            if (this.buffer[index] != 13 || this.buffer[index + 1] != 10) continue;
            index += 2;
        }
        return dataSets;
    }

    private int getBaudRate(int baudCharacter) {
        int result = -1;
        switch (baudCharacter) {
            case 48: {
                result = 300;
                break;
            }
            case 49: {
                result = 600;
                break;
            }
            case 50: {
                result = 1200;
                break;
            }
            case 51: {
                result = 2400;
                break;
            }
            case 52: {
                result = 4800;
                break;
            }
            case 53: {
                result = 9600;
                break;
            }
            case 54: {
                result = 19200;
            }
        }
        return result;
    }
}

