/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j62056;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openmuc.j62056.DataSet;
import org.openmuc.j62056.internal.Bcc;
import org.openmuc.j62056.internal.HexConverter;
import org.openmuc.j62056.internal.IdentificationMessage;
import org.openmuc.jrxtx.SerialPort;

public class DataMessage {
    private final String manufacturerId;
    private final String meterId;
    private final String enhancedId;
    private final List<DataSet> dataSets;

    private DataMessage(String manufacturerId, String meterId, String enhancedId, List<DataSet> dataSets) {
        this.manufacturerId = manufacturerId;
        this.meterId = meterId;
        this.enhancedId = enhancedId;
        this.dataSets = dataSets;
    }

    static DataMessage readModeAbcDataMessage(DataInputStream is, IdentificationMessage identificationMessage) throws IOException {
        DataSet dataSet;
        byte b = is.readByte();
        if (b != 2) {
            throw new IOException("Received unexpected data message start byte: " + HexConverter.toShortHexString(b));
        }
        Bcc bcc = new Bcc();
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        while ((dataSet = DataSet.readDataSet(is, bcc)) != null) {
            dataSets.add(dataSet);
        }
        b = is.readByte();
        if (b != 13) {
            throw new IOException("Received unexpected byte at end of data message: " + HexConverter.toShortHexString(b) + ", expected: '\r'(");
        }
        b = is.readByte();
        if (b != 10) {
            throw new IOException("Received unexpected byte at end of data message: " + HexConverter.toShortHexString(b) + ", expected: '\n'");
        }
        b = is.readByte();
        if (b != 3) {
            throw new IOException("Received unexpected byte at end of data message: " + HexConverter.toShortHexString(b) + ", expected: 0x03");
        }
        bcc.value = (byte)(bcc.value ^ 4);
        b = is.readByte();
        if (b != bcc.value) {
            throw new IOException("Block check character (BCC) does not match. Received: " + HexConverter.toHexString(b) + ", expected: " + HexConverter.toHexString(bcc.value));
        }
        return new DataMessage(identificationMessage.getManufactureId(), identificationMessage.getMeterId(), identificationMessage.getEnhancedId(), dataSets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DataMessage readModeDDataMessage(DataInputStream is, IdentificationMessage identificationMessage, SerialPort serialPort) throws IOException {
        byte b = is.readByte();
        if (b != 13) {
            throw new IOException("Received unexpected byte at beginning of data message: " + HexConverter.toShortHexString(b) + ", expected: '\r'(");
        }
        serialPort.setSerialPortTimeout(500);
        try {
            DataSet dataSet;
            b = is.readByte();
            if (b != 10) {
                throw new IOException("Received unexpected byte at beginning of data message: " + HexConverter.toShortHexString(b) + ", expected: '\n'");
            }
            ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
            while ((dataSet = DataSet.readDataSet(is, new Bcc())) != null) {
                dataSets.add(dataSet);
            }
            b = is.readByte();
            if (b != 13) {
                throw new IOException("Received unexpected byte at end of data message: " + HexConverter.toShortHexString(b) + ", expected: '\r'(");
            }
            b = is.readByte();
            if (b != 10) {
                throw new IOException("Received unexpected byte at end of data message: " + HexConverter.toShortHexString(b) + ", expected: '\n'");
            }
            DataMessage dataMessage = new DataMessage(identificationMessage.getManufactureId(), identificationMessage.getMeterId(), identificationMessage.getEnhancedId(), dataSets);
            return dataMessage;
        }
        finally {
            serialPort.setSerialPortTimeout(0);
        }
    }

    public String getManufacturerId() {
        return this.manufacturerId;
    }

    public String getMeterId() {
        return this.meterId;
    }

    public String getEnhancedId() {
        return this.enhancedId;
    }

    public List<DataSet> getDataSets() {
        return this.dataSets;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\n\t\"data message\": {\n\t\t\"manufacturer ID\": \"").append(this.manufacturerId).append("\",\n\t\t\"meter ID\": \"").append(this.meterId).append("\",\n\t\t\"enhanced ID/capability\": \"").append(this.enhancedId).append("\"").append(IdentificationMessage.getEnhancedIdDescription(this.enhancedId)).append(",\n\t\t\"data block\": {");
        for (DataSet dataSet : this.dataSets) {
            sb.append("\n\t\t\t").append(dataSet.toString()).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("\n\t\t}\n\t}\n}");
        return sb.toString();
    }
}

