/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j62056;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.j62056.internal.Bcc;
import org.openmuc.j62056.internal.Helper;
import org.openmuc.j62056.internal.HexConverter;

public class DataSet {
    private final String address;
    private final String value;
    private final String unit;
    private static final int BUFFER_LENGTH = 100;

    private DataSet(String id, String value, String unit) {
        this.address = id;
        this.value = value;
        this.unit = unit;
    }

    static DataSet readDataSet(DataInputStream is, Bcc bcc) throws IOException {
        String unit;
        byte b = Helper.readByteAndCalculateBcc(is, bcc);
        if (b == 13) {
            b = Helper.readByteAndCalculateBcc(is, bcc);
            if (b != 10) {
                throw new IOException("Received unexpected data message start byte: " + HexConverter.toShortHexString(b));
            }
            b = Helper.readByteAndCalculateBcc(is, bcc);
        }
        if (b == 33) {
            return null;
        }
        byte[] buffer = new byte[100];
        int i = 0;
        while (b != 40) {
            if (i == 100) {
                throw new IOException("Expected '(' character not received.");
            }
            buffer[i] = b;
            ++i;
            b = Helper.readByteAndCalculateBcc(is, bcc);
        }
        String address = new String(buffer, 0, i, Helper.ASCII_CHARSET);
        i = 0;
        while ((b = Helper.readByteAndCalculateBcc(is, bcc)) != 42 && b != 41) {
            if (i == 100) {
                throw new IOException("Expected '*' or ')' character not received.");
            }
            buffer[i] = b;
            ++i;
        }
        String value = new String(buffer, 0, i, Helper.ASCII_CHARSET);
        if (b == 41) {
            unit = "";
        } else {
            i = 0;
            while ((b = Helper.readByteAndCalculateBcc(is, bcc)) != 41) {
                if (i == 100) {
                    throw new IOException("Expected ')' character not received.");
                }
                buffer[i] = b;
                ++i;
            }
            unit = new String(buffer, 0, i, Helper.ASCII_CHARSET);
        }
        return new DataSet(address, value, unit);
    }

    public String getAddress() {
        return this.address;
    }

    public String getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        return "\"data set\": {\"address\": \"" + this.address + "\", \"value\": \"" + this.value + "\", \"unit\": \"" + this.unit + "\"}";
    }
}

