/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.j62056.internal;

import java.io.DataOutputStream;
import java.io.IOException;
import org.openmuc.j62056.internal.AcknowledgeMode;
import org.openmuc.j62056.internal.ProtocolControlCharacter;

public class AcknowledgeMessage {
    private final byte[] acknowledgeMessageBytes;
    private final ProtocolControlCharacter protocolControlCharacter;
    private final AcknowledgeMode acknowledgeMode;
    private final int baudRate;

    public AcknowledgeMessage(int baudRate, ProtocolControlCharacter protocolControlCharacter, AcknowledgeMode acknowledgeMode) {
        this.baudRate = baudRate;
        this.protocolControlCharacter = protocolControlCharacter;
        this.acknowledgeMode = acknowledgeMode;
        this.acknowledgeMessageBytes = new byte[]{6, (byte)protocolControlCharacter.value(), AcknowledgeMessage.getCodeFromBaudRate(baudRate), (byte)acknowledgeMode.getValue(), 13, 10};
    }

    public void send(DataOutputStream os) throws IOException {
        os.write(this.acknowledgeMessageBytes);
        os.flush();
    }

    public String toString() {
        return "{\"acknowledge message\": {\"protocol control character\": \"" + (Object)((Object)this.protocolControlCharacter) + "\", \"baud rate\": " + this.baudRate + ", \"acknowledge mode\": \"" + (Object)((Object)this.acknowledgeMode) + "\"}}";
    }

    private static byte getCodeFromBaudRate(int baudRate) {
        switch (baudRate) {
            case 300: {
                return 48;
            }
            case 600: {
                return 49;
            }
            case 1200: {
                return 50;
            }
            case 2400: {
                return 51;
            }
            case 4800: {
                return 52;
            }
            case 9600: {
                return 53;
            }
            case 19200: {
                return 54;
            }
        }
        throw new IllegalStateException("Unexpected baudRate: " + baudRate);
    }
}

